package com.xforceplus.wilmar.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.CentralUser;
import com.xforceplus.wilmar.service.ICentralUserService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-02
 */
@RestController
public class CentralUserController {

  @Autowired
  private ICentralUserService centralUserServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param centralUser ${table.comment}
   * @return
   */
  @GetMapping("/centralusers" )
  public XfR getCentralUsers(XfPage page, CentralUser centralUser) {
    return XfR.ok(centralUserServiceImpl.page(page, Wrappers.query(centralUser)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/centralusers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(centralUserServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param centralUser ${table.comment}
   * @return XfR
   */
  @PostMapping("/centralusers")
  public XfR save(@RequestBody CentralUser centralUser) {
     return XfR.ok(centralUserServiceImpl.save(centralUser));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param centralUser ${table.comment}
   * @return XfR
   */
  @PutMapping("/centralusers/{id}")
  public XfR putUpdate(@RequestBody CentralUser centralUser,@PathVariable Long id) {
      centralUser.setId(id);
      return XfR.ok(centralUserServiceImpl.updateById(centralUser));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param centralUser ${table.comment}
   * @return XfR
   */
  @PatchMapping("/centralusers/{id}")
  public XfR patchUpdate(@RequestBody CentralUser centralUser,@PathVariable Long id) {
      CentralUser upcentralUser = centralUserServiceImpl.getById(id);
      if(upcentralUser != null){
        upcentralUser = ObjectCopyUtils.copyProperties(centralUser,upcentralUser,true);
      }
      return XfR.ok(centralUserServiceImpl.updateById(upcentralUser));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/centralusers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(centralUserServiceImpl.removeById(id));
  }

  @PostMapping("/centralusers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "centraluser");
      params.put("request", condition);

     return XfR.ok(centralUserServiceImpl.querys(params));
  }

}
