package com.xforceplus.wilmar.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.GoodsReceive;
import com.xforceplus.wilmar.service.IGoodsReceiveService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-02
 */
@RestController
public class GoodsReceiveController {

  @Autowired
  private IGoodsReceiveService goodsReceiveServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsReceive ${table.comment}
   * @return
   */
  @GetMapping("/goodsreceives" )
  public XfR getGoodsReceives(XfPage page, GoodsReceive goodsReceive) {
    return XfR.ok(goodsReceiveServiceImpl.page(page, Wrappers.query(goodsReceive)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsreceives/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsReceiveServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param goodsReceive ${table.comment}
   * @return XfR
   */
  @PostMapping("/goodsreceives")
  public XfR save(@RequestBody GoodsReceive goodsReceive) {
     return XfR.ok(goodsReceiveServiceImpl.save(goodsReceive));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param goodsReceive ${table.comment}
   * @return XfR
   */
  @PutMapping("/goodsreceives/{id}")
  public XfR putUpdate(@RequestBody GoodsReceive goodsReceive,@PathVariable Long id) {
      goodsReceive.setId(id);
      return XfR.ok(goodsReceiveServiceImpl.updateById(goodsReceive));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param goodsReceive ${table.comment}
   * @return XfR
   */
  @PatchMapping("/goodsreceives/{id}")
  public XfR patchUpdate(@RequestBody GoodsReceive goodsReceive,@PathVariable Long id) {
      GoodsReceive upgoodsReceive = goodsReceiveServiceImpl.getById(id);
      if(upgoodsReceive != null){
        upgoodsReceive = ObjectCopyUtils.copyProperties(goodsReceive,upgoodsReceive,true);
      }
      return XfR.ok(goodsReceiveServiceImpl.updateById(upgoodsReceive));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsreceives/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsReceiveServiceImpl.removeById(id));
  }

  @PostMapping("/goodsreceives/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "goodsreceive");
      params.put("request", condition);

     return XfR.ok(goodsReceiveServiceImpl.querys(params));
  }

}
