package com.xforceplus.wilmar.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.Banks;
import com.xforceplus.wilmar.service.IBanksService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-27
 */
@RestController
public class BanksController {

  @Autowired
  private IBanksService banksServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param banks ${table.comment}
   * @return
   */
  @GetMapping("/bankss" )
  public XfR getBankss(XfPage page, Banks banks) {
    return XfR.ok(banksServiceImpl.page(page, Wrappers.query(banks)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bankss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(banksServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param banks ${table.comment}
   * @return XfR
   */
  @PostMapping("/bankss")
  public XfR save(@RequestBody Banks banks) {
     return XfR.ok(banksServiceImpl.save(banks));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param banks ${table.comment}
   * @return XfR
   */
  @PutMapping("/bankss/{id}")
  public XfR putUpdate(@RequestBody Banks banks,@PathVariable Long id) {
      banks.setId(id);
      return XfR.ok(banksServiceImpl.updateById(banks));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param banks ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bankss/{id}")
  public XfR patchUpdate(@RequestBody Banks banks,@PathVariable Long id) {
      Banks upbanks = banksServiceImpl.getById(id);
      if(upbanks != null){
        upbanks = ObjectCopyUtils.copyProperties(banks,upbanks,true);
      }
      return XfR.ok(banksServiceImpl.updateById(upbanks));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bankss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(banksServiceImpl.removeById(id));
  }

  @PostMapping("/bankss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "banks");
      params.put("request", condition);

     return XfR.ok(banksServiceImpl.querys(params));
  }

}
