package com.xforceplus.wilmar.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.LossTrace;
import com.xforceplus.wilmar.service.ILossTraceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-27
 */
@RestController
public class LossTraceController {

  @Autowired
  private ILossTraceService lossTraceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lossTrace ${table.comment}
   * @return
   */
  @GetMapping("/losstraces" )
  public XfR getLossTraces(XfPage page, LossTrace lossTrace) {
    return XfR.ok(lossTraceServiceImpl.page(page, Wrappers.query(lossTrace)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/losstraces/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lossTraceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param lossTrace ${table.comment}
   * @return XfR
   */
  @PostMapping("/losstraces")
  public XfR save(@RequestBody LossTrace lossTrace) {
     return XfR.ok(lossTraceServiceImpl.save(lossTrace));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param lossTrace ${table.comment}
   * @return XfR
   */
  @PutMapping("/losstraces/{id}")
  public XfR putUpdate(@RequestBody LossTrace lossTrace,@PathVariable Long id) {
      lossTrace.setId(id);
      return XfR.ok(lossTraceServiceImpl.updateById(lossTrace));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param lossTrace ${table.comment}
   * @return XfR
   */
  @PatchMapping("/losstraces/{id}")
  public XfR patchUpdate(@RequestBody LossTrace lossTrace,@PathVariable Long id) {
      LossTrace uplossTrace = lossTraceServiceImpl.getById(id);
      if(uplossTrace != null){
        uplossTrace = ObjectCopyUtils.copyProperties(lossTrace,uplossTrace,true);
      }
      return XfR.ok(lossTraceServiceImpl.updateById(uplossTrace));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/losstraces/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lossTraceServiceImpl.removeById(id));
  }

  @PostMapping("/losstraces/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "losstrace");
      params.put("request", condition);

     return XfR.ok(lossTraceServiceImpl.querys(params));
  }

}
