package com.xforceplus.wilmar.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.SalesList;
import com.xforceplus.wilmar.service.ISalesListService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-07-27
 */
@RestController
public class SalesListController {

  @Autowired
  private ISalesListService salesListServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesList ${table.comment}
   * @return
   */
  @GetMapping("/saleslists" )
  public XfR getSalesLists(XfPage page, SalesList salesList) {
    return XfR.ok(salesListServiceImpl.page(page, Wrappers.query(salesList)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/saleslists/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesListServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param salesList ${table.comment}
   * @return XfR
   */
  @PostMapping("/saleslists")
  public XfR save(@RequestBody SalesList salesList) {
     return XfR.ok(salesListServiceImpl.save(salesList));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param salesList ${table.comment}
   * @return XfR
   */
  @PutMapping("/saleslists/{id}")
  public XfR putUpdate(@RequestBody SalesList salesList,@PathVariable Long id) {
      salesList.setId(id);
      return XfR.ok(salesListServiceImpl.updateById(salesList));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param salesList ${table.comment}
   * @return XfR
   */
  @PatchMapping("/saleslists/{id}")
  public XfR patchUpdate(@RequestBody SalesList salesList,@PathVariable Long id) {
      SalesList upsalesList = salesListServiceImpl.getById(id);
      if(upsalesList != null){
        upsalesList = ObjectCopyUtils.copyProperties(salesList,upsalesList,true);
      }
      return XfR.ok(salesListServiceImpl.updateById(upsalesList));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/saleslists/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesListServiceImpl.removeById(id));
  }

  @PostMapping("/saleslists/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "saleslist");
      params.put("request", condition);

     return XfR.ok(salesListServiceImpl.querys(params));
  }

}
