package com.xforceplus.wilmar.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.PreOrder;
import com.xforceplus.wilmar.service.IPreOrderService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-05-26
 */
@RestController
public class PreOrderController {

  @Autowired
  private IPreOrderService preOrderServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param preOrder ${table.comment}
   * @return
   */
  @GetMapping("/preorders" )
  public XfR getPreOrders(XfPage page, PreOrder preOrder) {
    return XfR.ok(preOrderServiceImpl.page(page, Wrappers.query(preOrder)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/preorders/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(preOrderServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param preOrder ${table.comment}
   * @return XfR
   */
  @PostMapping("/preorders")
  public XfR save(@RequestBody PreOrder preOrder) {
     return XfR.ok(preOrderServiceImpl.save(preOrder));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param preOrder ${table.comment}
   * @return XfR
   */
  @PutMapping("/preorders/{id}")
  public XfR putUpdate(@RequestBody PreOrder preOrder,@PathVariable Long id) {
      preOrder.setId(id);
      return XfR.ok(preOrderServiceImpl.updateById(preOrder));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param preOrder ${table.comment}
   * @return XfR
   */
  @PatchMapping("/preorders/{id}")
  public XfR patchUpdate(@RequestBody PreOrder preOrder,@PathVariable Long id) {
      PreOrder uppreOrder = preOrderServiceImpl.getById(id);
      if(uppreOrder != null){
        uppreOrder = ObjectCopyUtils.copyProperties(preOrder,uppreOrder,true);
      }
      return XfR.ok(preOrderServiceImpl.updateById(uppreOrder));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/preorders/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(preOrderServiceImpl.removeById(id));
  }

  @PostMapping("/preorders/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "preorder");
      params.put("request", condition);

     return XfR.ok(preOrderServiceImpl.querys(params));
  }

}
