package com.xforceplus.wilmar.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.wilmar.entity.ScanInvoice;
import com.xforceplus.wilmar.service.IScanInvoiceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author wangzheng
 * @date 2020-06-19
 */
@RestController
public class ScanInvoiceController {

  @Autowired
  private IScanInvoiceService scanInvoiceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param scanInvoice ${table.comment}
   * @return
   */
  @GetMapping("/scaninvoices" )
  public XfR getScanInvoices(XfPage page, ScanInvoice scanInvoice) {
    return XfR.ok(scanInvoiceServiceImpl.page(page, Wrappers.query(scanInvoice)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/scaninvoices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(scanInvoiceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param scanInvoice ${table.comment}
   * @return XfR
   */
  @PostMapping("/scaninvoices")
  public XfR save(@RequestBody ScanInvoice scanInvoice) {
     return XfR.ok(scanInvoiceServiceImpl.save(scanInvoice));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param scanInvoice ${table.comment}
   * @return XfR
   */
  @PutMapping("/scaninvoices/{id}")
  public XfR putUpdate(@RequestBody ScanInvoice scanInvoice,@PathVariable Long id) {
      scanInvoice.setId(id);
      return XfR.ok(scanInvoiceServiceImpl.updateById(scanInvoice));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param scanInvoice ${table.comment}
   * @return XfR
   */
  @PatchMapping("/scaninvoices/{id}")
  public XfR patchUpdate(@RequestBody ScanInvoice scanInvoice,@PathVariable Long id) {
      ScanInvoice upscanInvoice = scanInvoiceServiceImpl.getById(id);
      if(upscanInvoice != null){
        upscanInvoice = ObjectCopyUtils.copyProperties(scanInvoice,upscanInvoice,true);
      }
      return XfR.ok(scanInvoiceServiceImpl.updateById(upscanInvoice));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/scaninvoices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(scanInvoiceServiceImpl.removeById(id));
  }

  @PostMapping("/scaninvoices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
      Map<String, Object> params = new HashMap();
      params.put("tableName", "scaninvoice");
      params.put("request", condition);

     return XfR.ok(scanInvoiceServiceImpl.querys(params));
  }

}
