package com.xforceplus.wilmarma.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 物料单位
 * </p>
 *
 * @author ultraman
 * @since 2024-03-15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Marm implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 主键ID
   */
  private String materialunitid;

  /**
   * 物料ID
   */
  private String materialid;

  /**
   * 物料号
   */
  private String matnr;

  /**
   * 帐面库存单位的可选计量单位
   */
  private String meinh;

  /**
   * 基本计量单位转换分子
   */
  private String umrez;

  /**
   * 转换为基本计量单位的分母
   */
  private String umren;

  /**
   * 长度
   */
  private String laeng;

  /**
   * 宽度
   */
  private String breit;

  /**
   * 高度
   */
  private String hoehe;

  /**
   * 长度/宽度/高度的尺寸单位
   */
  private String meabm;

  /**
   * 体积
   */
  private String volum;

  /**
   * 体积单位
   */
  private String voleh;

  /**
   * 毛重
   */
  private String brgew;

  /**
   * 重量单位
   */
  private String gewei;

  /**
   * 单位备注
   */
  private String unitMark;

  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createdate;

  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updatedate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;


  /**
   * 对一关联关系 关联对象 mara
   */
    private Long marmId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("materialunitid", materialunitid);
      map.put("materialid", materialid);
      map.put("matnr", matnr);
      map.put("meinh", meinh);
      map.put("umrez", umrez);
      map.put("umren", umren);
      map.put("laeng", laeng);
      map.put("breit", breit);
      map.put("hoehe", hoehe);
      map.put("meabm", meabm);
      map.put("volum", volum);
      map.put("voleh", voleh);
      map.put("brgew", brgew);
      map.put("gewei", gewei);
      map.put("unit_mark", unitMark);
      map.put("createdate", BocpGenUtils.toTimestamp(createdate));
      map.put("updatedate", BocpGenUtils.toTimestamp(updatedate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

       map.put("marm.id", marmId);
      return map;
  }

  public static Marm fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Marm entity = new Marm();
    if(map.containsKey("materialunitid")) {
      Object obj = map.get("materialunitid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialunitid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialid")) {
      Object obj = map.get("materialid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterialid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matnr")) {
      Object obj = map.get("matnr");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatnr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meinh")) {
      Object obj = map.get("meinh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMeinh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("umrez")) {
      Object obj = map.get("umrez");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUmrez((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("umren")) {
      Object obj = map.get("umren");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUmren((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("laeng")) {
      Object obj = map.get("laeng");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLaeng((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("breit")) {
      Object obj = map.get("breit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBreit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hoehe")) {
      Object obj = map.get("hoehe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHoehe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meabm")) {
      Object obj = map.get("meabm");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMeabm((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volum")) {
      Object obj = map.get("volum");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolum((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("voleh")) {
      Object obj = map.get("voleh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVoleh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brgew")) {
      Object obj = map.get("brgew");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrgew((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gewei")) {
      Object obj = map.get("gewei");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGewei((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit_mark")) {
      Object obj = map.get("unit_mark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnitMark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createdate")) {
      Object obj = map.get("createdate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreatedate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreatedate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreatedate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreatedate(null);
      }
    }
    if(map.containsKey("updatedate")) {
      Object obj = map.get("updatedate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdatedate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdatedate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdatedate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdatedate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("marm.id")) {
        Object obj = map.get("marm.id");
      if(obj instanceof Long) {
        entity.setMarmId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setMarmId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("materialunitid")) {
      Object obj = map.get("materialunitid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialunitid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialid")) {
      Object obj = map.get("materialid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matnr")) {
      Object obj = map.get("matnr");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatnr((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("meinh")) {
      Object obj = map.get("meinh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMeinh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("umrez")) {
      Object obj = map.get("umrez");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUmrez((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("umren")) {
      Object obj = map.get("umren");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUmren((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("laeng")) {
      Object obj = map.get("laeng");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLaeng((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("breit")) {
      Object obj = map.get("breit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBreit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hoehe")) {
      Object obj = map.get("hoehe");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHoehe((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("meabm")) {
      Object obj = map.get("meabm");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMeabm((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("volum")) {
      Object obj = map.get("volum");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVolum((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("voleh")) {
      Object obj = map.get("voleh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVoleh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brgew")) {
      Object obj = map.get("brgew");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrgew((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gewei")) {
      Object obj = map.get("gewei");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGewei((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit_mark")) {
      Object obj = map.get("unit_mark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnitMark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createdate")) {
      Object obj = map.get("createdate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreatedate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreatedate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreatedate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreatedate(null);
      }
    }
    if(map.containsKey("updatedate")) {
      Object obj = map.get("updatedate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdatedate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdatedate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdatedate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdatedate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("marm.id")) {
        Object obj = map.get("marm.id");
        if(obj instanceof Long) {
          this.setMarmId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setMarmId(Long.parseLong((String)obj));
        }
      }
  }
}
