package com.xforceplus.xforcepack.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.xforcepack.entity.OperationHistory;
import com.xforceplus.xforcepack.service.IOperationHistoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-02
 */
@RestController
public class OperationHistoryController {

  @Autowired
  private IOperationHistoryService operationHistoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param operationHistory ${table.comment}
   * @return
   */
  @GetMapping("/operationhistorys" )
  public XfR getOperationHistorys(XfPage page, OperationHistory operationHistory) {
    return XfR.ok(operationHistoryServiceImpl.page(page, Wrappers.query(operationHistory)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/operationhistorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(operationHistoryServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param operationHistory ${table.comment}
   * @return XfR
   */
  @PostMapping("/operationhistorys")
  public XfR save(@RequestBody OperationHistory operationHistory) {
     return XfR.ok(operationHistoryServiceImpl.save(operationHistory));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param operationHistory ${table.comment}
   * @return XfR
   */
  @PutMapping("/operationhistorys/{id}")
  public XfR putUpdate(@RequestBody OperationHistory operationHistory,@PathVariable Long id) {
      operationHistory.setId(id);
      return XfR.ok(operationHistoryServiceImpl.updateById(operationHistory));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param operationHistory ${table.comment}
   * @return XfR
   */
  @PatchMapping("/operationhistorys/{id}")
  public XfR patchUpdate(@RequestBody OperationHistory operationHistory,@PathVariable Long id) {
      OperationHistory upoperationHistory = operationHistoryServiceImpl.getById(id);
      if(upoperationHistory != null){
        upoperationHistory = ObjectCopyUtils.copyProperties(operationHistory,upoperationHistory,true);
      }
      return XfR.ok(operationHistoryServiceImpl.updateById(upoperationHistory));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/operationhistorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(operationHistoryServiceImpl.removeById(id));
  }

  @PostMapping("/operationhistorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "operation_history");
     params.put("request", condition);

     return XfR.ok(operationHistoryServiceImpl.querys(params));
  }

}
