package com.xforceplus.xforcepack.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.xforcepack.entity.PageMicroLibRuntime;
import com.xforceplus.xforcepack.service.IPageMicroLibRuntimeService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-08-02
 */
@RestController
public class PageMicroLibRuntimeController {

  @Autowired
  private IPageMicroLibRuntimeService pageMicroLibRuntimeServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pageMicroLibRuntime ${table.comment}
   * @return
   */
  @GetMapping("/pagemicrolibruntimes" )
  public XfR getPageMicroLibRuntimes(XfPage page, PageMicroLibRuntime pageMicroLibRuntime) {
    return XfR.ok(pageMicroLibRuntimeServiceImpl.page(page, Wrappers.query(pageMicroLibRuntime)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pagemicrolibruntimes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pageMicroLibRuntimeServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pageMicroLibRuntime ${table.comment}
   * @return XfR
   */
  @PostMapping("/pagemicrolibruntimes")
  public XfR save(@RequestBody PageMicroLibRuntime pageMicroLibRuntime) {
     return XfR.ok(pageMicroLibRuntimeServiceImpl.save(pageMicroLibRuntime));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pageMicroLibRuntime ${table.comment}
   * @return XfR
   */
  @PutMapping("/pagemicrolibruntimes/{id}")
  public XfR putUpdate(@RequestBody PageMicroLibRuntime pageMicroLibRuntime,@PathVariable Long id) {
      pageMicroLibRuntime.setId(id);
      return XfR.ok(pageMicroLibRuntimeServiceImpl.updateById(pageMicroLibRuntime));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pageMicroLibRuntime ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pagemicrolibruntimes/{id}")
  public XfR patchUpdate(@RequestBody PageMicroLibRuntime pageMicroLibRuntime,@PathVariable Long id) {
      PageMicroLibRuntime uppageMicroLibRuntime = pageMicroLibRuntimeServiceImpl.getById(id);
      if(uppageMicroLibRuntime != null){
        uppageMicroLibRuntime = ObjectCopyUtils.copyProperties(pageMicroLibRuntime,uppageMicroLibRuntime,true);
      }
      return XfR.ok(pageMicroLibRuntimeServiceImpl.updateById(uppageMicroLibRuntime));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pagemicrolibruntimes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pageMicroLibRuntimeServiceImpl.removeById(id));
  }

  @PostMapping("/pagemicrolibruntimes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "page_micro_lib_runtime");
     params.put("request", condition);

     return XfR.ok(pageMicroLibRuntimeServiceImpl.querys(params));
  }

}
