package com.xforceplus.xforcepack.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.xforcepack.entity.GrayReleaseStrategy;
import com.xforceplus.xforcepack.service.IGrayReleaseStrategyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-28
 */
@RestController
public class GrayReleaseStrategyController {

  @Autowired
  private IGrayReleaseStrategyService grayReleaseStrategyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param grayReleaseStrategy ${table.comment}
   * @return
   */
  @GetMapping("/grayreleasestrategys" )
  public XfR getGrayReleaseStrategys(XfPage page, GrayReleaseStrategy grayReleaseStrategy) {
    return XfR.ok(grayReleaseStrategyServiceImpl.page(page, Wrappers.query(grayReleaseStrategy)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/grayreleasestrategys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(grayReleaseStrategyServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param grayReleaseStrategy ${table.comment}
   * @return XfR
   */
  @PostMapping("/grayreleasestrategys")
  public XfR save(@RequestBody GrayReleaseStrategy grayReleaseStrategy) {
     return XfR.ok(grayReleaseStrategyServiceImpl.save(grayReleaseStrategy));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param grayReleaseStrategy ${table.comment}
   * @return XfR
   */
  @PutMapping("/grayreleasestrategys/{id}")
  public XfR putUpdate(@RequestBody GrayReleaseStrategy grayReleaseStrategy,@PathVariable Long id) {
      grayReleaseStrategy.setId(id);
      return XfR.ok(grayReleaseStrategyServiceImpl.updateById(grayReleaseStrategy));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param grayReleaseStrategy ${table.comment}
   * @return XfR
   */
  @PatchMapping("/grayreleasestrategys/{id}")
  public XfR patchUpdate(@RequestBody GrayReleaseStrategy grayReleaseStrategy,@PathVariable Long id) {
      GrayReleaseStrategy upgrayReleaseStrategy = grayReleaseStrategyServiceImpl.getById(id);
      if(upgrayReleaseStrategy != null){
        upgrayReleaseStrategy = ObjectCopyUtils.copyProperties(grayReleaseStrategy,upgrayReleaseStrategy,true);
      }
      return XfR.ok(grayReleaseStrategyServiceImpl.updateById(upgrayReleaseStrategy));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/grayreleasestrategys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(grayReleaseStrategyServiceImpl.removeById(id));
  }

  @PostMapping("/grayreleasestrategys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "gray_release_strategy");
     params.put("request", condition);

     return XfR.ok(grayReleaseStrategyServiceImpl.querys(params));
  }

}
