package com.xforceplus.xforcepack.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.xforcepack.entity.MicroLib;
import com.xforceplus.xforcepack.service.IMicroLibService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-28
 */
@RestController
public class MicroLibController {

  @Autowired
  private IMicroLibService microLibServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param microLib ${table.comment}
   * @return
   */
  @GetMapping("/microlibs" )
  public XfR getMicroLibs(XfPage page, MicroLib microLib) {
    return XfR.ok(microLibServiceImpl.page(page, Wrappers.query(microLib)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/microlibs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(microLibServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param microLib ${table.comment}
   * @return XfR
   */
  @PostMapping("/microlibs")
  public XfR save(@RequestBody MicroLib microLib) {
     return XfR.ok(microLibServiceImpl.save(microLib));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param microLib ${table.comment}
   * @return XfR
   */
  @PutMapping("/microlibs/{id}")
  public XfR putUpdate(@RequestBody MicroLib microLib,@PathVariable Long id) {
      microLib.setId(id);
      return XfR.ok(microLibServiceImpl.updateById(microLib));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param microLib ${table.comment}
   * @return XfR
   */
  @PatchMapping("/microlibs/{id}")
  public XfR patchUpdate(@RequestBody MicroLib microLib,@PathVariable Long id) {
      MicroLib upmicroLib = microLibServiceImpl.getById(id);
      if(upmicroLib != null){
        upmicroLib = ObjectCopyUtils.copyProperties(microLib,upmicroLib,true);
      }
      return XfR.ok(microLibServiceImpl.updateById(upmicroLib));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/microlibs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(microLibServiceImpl.removeById(id));
  }

  @PostMapping("/microlibs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "micro_lib");
     params.put("request", condition);

     return XfR.ok(microLibServiceImpl.querys(params));
  }

}
