package com.xforceplus.xforcepack.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.xforcepack.entity.PageMicroLib;
import com.xforceplus.xforcepack.service.IPageMicroLibService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-11-28
 */
@RestController
public class PageMicroLibController {

  @Autowired
  private IPageMicroLibService pageMicroLibServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pageMicroLib ${table.comment}
   * @return
   */
  @GetMapping("/pagemicrolibs" )
  public XfR getPageMicroLibs(XfPage page, PageMicroLib pageMicroLib) {
    return XfR.ok(pageMicroLibServiceImpl.page(page, Wrappers.query(pageMicroLib)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pagemicrolibs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pageMicroLibServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pageMicroLib ${table.comment}
   * @return XfR
   */
  @PostMapping("/pagemicrolibs")
  public XfR save(@RequestBody PageMicroLib pageMicroLib) {
     return XfR.ok(pageMicroLibServiceImpl.save(pageMicroLib));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pageMicroLib ${table.comment}
   * @return XfR
   */
  @PutMapping("/pagemicrolibs/{id}")
  public XfR putUpdate(@RequestBody PageMicroLib pageMicroLib,@PathVariable Long id) {
      pageMicroLib.setId(id);
      return XfR.ok(pageMicroLibServiceImpl.updateById(pageMicroLib));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pageMicroLib ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pagemicrolibs/{id}")
  public XfR patchUpdate(@RequestBody PageMicroLib pageMicroLib,@PathVariable Long id) {
      PageMicroLib uppageMicroLib = pageMicroLibServiceImpl.getById(id);
      if(uppageMicroLib != null){
        uppageMicroLib = ObjectCopyUtils.copyProperties(pageMicroLib,uppageMicroLib,true);
      }
      return XfR.ok(pageMicroLibServiceImpl.updateById(uppageMicroLib));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pagemicrolibs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pageMicroLibServiceImpl.removeById(id));
  }

  @PostMapping("/pagemicrolibs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "page_micro_lib");
     params.put("request", condition);

     return XfR.ok(pageMicroLibServiceImpl.querys(params));
  }

}
