package com.xforceplus.xplat.aws.boot2;

import java.util.Map;
import java.util.Properties;

import javax.annotation.PostConstruct;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

import com.xforceplus.xplat.aws.s3.S3Service;
import com.xforceplus.xplat.aws.s3.singleton.S3ClientSingleton;
import com.xforceplus.xplat.aws.spring.utils.SpringBootAssit;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplat.aws.sqs.singleton.SqsClientSingleton;

import lombok.extern.slf4j.Slf4j;
import net.wicp.tams.common.Conf;

@Slf4j
@Configuration
@Order(Ordered.HIGHEST_PRECEDENCE)
public class ConfigInit {
	// 为了非spring程序调用spring程序
	public static ApplicationContext context;
	@Autowired
	private SpringBootAssit springBootAssit;

	private String[] addPre = new String[] { "xplat.aws.session.", "common.apiext.thread.pool." };

	private String[] addSingle = new String[] {};

	@PostConstruct
	private void init() {
		Properties inputpamas = new Properties();
		Properties tpProps = Conf.copyProperties();
		addOtherConf(tpProps);
		Map<String, String> allMap = springBootAssit.findAllProps();
		/*for (Object key : tpProps.keySet()) {
			String keystr = String.valueOf(key);
			if (allMap.containsKey(keystr)) {
				inputpamas.put(keystr, allMap.get(keystr));
			}
		}*/
		for (String keystr : allMap.keySet()) {
			boolean needAdd = tpProps.containsKey(keystr);
			if (!needAdd) {
				for (String addPreEle : addPre) {
					if (keystr.startsWith(addPreEle)) {
						needAdd = true;
						break;
					}
				}
			}
			if (needAdd) {
				inputpamas.put(keystr, allMap.get(keystr));
			}
		}
		log.info("input parmas:{}", inputpamas.toString());
		Conf.overProp(inputpamas);
	}

	private void addOtherConf(Properties tpProps) {
		for (String needAddConf : addSingle) {
			if (!tpProps.containsKey(needAddConf)) {
				tpProps.put(needAddConf, "null");
			}
		}
	}

	@Configuration
	@Order(Ordered.HIGHEST_PRECEDENCE)
	protected class InitContext implements ApplicationContextAware {
		@Override
		public void setApplicationContext(ApplicationContext arg0) throws BeansException {
			ConfigInit.context = arg0;
		}
	}

	@Bean
	public SqsService newSqs() {
		return SqsClientSingleton.getInst().getSqs();
	}

	@Bean
	public S3Service newS3() {
		return S3ClientSingleton.getInst().getS3();
	}
}
