package com.xforceplus.xplat.aws.boot2;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Health.Builder;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;

import net.wicp.tams.common.thread.ThreadPool;

/***
 * 
 * @Description: 2.0访问路径 /actuator/health
 * @author zhoujunhui
 * @date 2019年1月10日
 */
@Component("SQS")
public class SqsHealth implements HealthIndicator {

	@Override
	public Health health() {
		Map<String, ExecutorService> poolmap = ThreadPool.getExecutorservicemap();

		Builder builder = new Health.Builder();
		boolean isUp = true;
		for (String key : poolmap.keySet()) {
			JSONObject temp = new JSONObject();
			ThreadPoolExecutor cur = (ThreadPoolExecutor) poolmap.get(key);
			int activeCount = cur.getActiveCount();// 活动线程大致数量
			long taskCount = cur.getTaskCount();// 曾经执行过任务总数
			if (cur.getQueue().size() > 0) {
				isUp = false;
				temp.put("status", "down");
			} else {
				temp.put("status", "up");
			}
			temp.put("activeCount", activeCount);
			temp.put("taskCount", taskCount);
			temp.put("maxSize", cur.getMaximumPoolSize());
			temp.put("coreSize", cur.getCorePoolSize());
			temp.put("queueSize", cur.getQueue().size());
			builder.withDetail(key, temp);

		}
		// if (isUp) {
		builder.up();
		// } else {
		// builder.down();
		// }
		return builder.build();
	}

}
