/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.xplat.stream.boot2;

import com.xforceplus.xplat.stream.BillingData;
import com.xforceplus.xplat.stream.common.kafka.KafkaService;
import com.xforceplus.xplat.stream.spring.annotation.KafkaSender;
import java.lang.reflect.Method;
import net.wicp.tams.common.apiext.StringUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class KafkaSenderAspect {
    private static final Logger log = LoggerFactory.getLogger(KafkaSenderAspect.class);
    @Autowired
    private KafkaService kafkaService;

    public KafkaSenderAspect() {
        System.out.println(1);
    }

    @Pointcut(value="@annotation(com.xforceplus.xplat.stream.spring.annotation.KafkaSender)")
    public void sendBilling() {
    }

    @Around(value="sendBilling()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = point.proceed();
        long time = System.currentTimeMillis() - beginTime;
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        KafkaSender kafkaSender = method.getAnnotation(KafkaSender.class);
        if (kafkaSender != null) {
            BillingData.Builder billingDataBuilder = BillingData.newBuilder();
            if (StringUtil.isNotNull((Object)kafkaSender.company())) {
                billingDataBuilder.setCompany(kafkaSender.company());
            }
            if (StringUtil.isNotNull((Object)kafkaSender.product())) {
                billingDataBuilder.setProduct(kafkaSender.product());
            }
            if (StringUtil.isNotNull((Object)kafkaSender.unit())) {
                billingDataBuilder.setUnit(kafkaSender.unit());
            }
            billingDataBuilder.setProductLine(kafkaSender.productLine());
            billingDataBuilder.setNum(kafkaSender.num());
            billingDataBuilder.setCreateDate(System.currentTimeMillis() + "");
            if (StringUtil.isNotNull((Object)kafkaSender.orderNo())) {
                billingDataBuilder.setOrderNo(kafkaSender.orderNo());
            }
            if (StringUtil.isNotNull((Object)kafkaSender.pricing())) {
                billingDataBuilder.setPricing(kafkaSender.pricing());
            }
            this.kafkaService.sendBillingData(billingDataBuilder);
            log.info("time:{} ,billing:{}", (Object)time, (Object)billingDataBuilder);
        }
        return result;
    }
}

