package com.xforceplus.yangzheng23135.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * testlookup042701
 * </p>
 *
 * @author ultraman
 * @since 2022-05-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Testlookup042701 implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * zfc
   */
  private String zfc;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * lookupzfc1
   */
  private String lookupzfc1;

  /**
   * lookupzfc2
   */
  private String lookupzfc2;

  /**
   * lookupzfc3
   */
  private String lookupzfc3;

  /**
   * lookupmjx1
   */
  private String lookupmjx1;

  /**
   * lookupmjx2
   */
  private String lookupmjx2;

  /**
   * lookupmjx3
   */
  private String lookupmjx3;

  /**
   * lookupzfc-非默认值
   */
  private String lookupfeimorenzhi;

  /**
   * lookupcszbh1
   */
  private String lookupcszbh1;

  /**
   * lookupjine1
   */
  private String lookupjine1;

  /**
   * lookupzfc4
   */
  private String lookupzfc4;

  /**
   * lookupzx4
   */
  private String lookupzx4;

  /**
   * lookupxs4
   */
  private String lookupxs4;

  /**
   * lookupbez4
   */
  private String lookupbez4;

  /**
   * lookupriqi4
   */
  private String lookupriqi4;

  /**
   * lookupmjx4
   */
  private String lookupmjx4;

  /**
   * lookupcszbh4
   */
  private String lookupcszbh4;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("lookupzfc1", lookupzfc1);
      map.put("lookupzfc2", lookupzfc2);
      map.put("lookupzfc3", lookupzfc3);
      map.put("lookupmjx1", lookupmjx1);
      map.put("lookupmjx2", lookupmjx2);
      map.put("lookupmjx3", lookupmjx3);
      map.put("lookupfeimorenzhi", lookupfeimorenzhi);
      map.put("lookupcszbh1", lookupcszbh1);
      map.put("lookupjine1", lookupjine1);
      map.put("lookupzfc4", lookupzfc4);
      map.put("lookupzx4", lookupzx4);
      map.put("lookupxs4", lookupxs4);
      map.put("lookupbez4", lookupbez4);
      map.put("lookupriqi4", lookupriqi4);
      map.put("lookupmjx4", lookupmjx4);
      map.put("lookupcszbh4", lookupcszbh4);
      return map;
  }

  public static Testlookup042701 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Testlookup042701 entity = new Testlookup042701();
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfc1")) {
      Object obj = map.get("lookupzfc1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupzfc1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfc2")) {
      Object obj = map.get("lookupzfc2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupzfc2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfc3")) {
      Object obj = map.get("lookupzfc3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupzfc3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupmjx1")) {
      Object obj = map.get("lookupmjx1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupmjx1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupmjx2")) {
      Object obj = map.get("lookupmjx2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupmjx2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupmjx3")) {
      Object obj = map.get("lookupmjx3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupmjx3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupfeimorenzhi")) {
      Object obj = map.get("lookupfeimorenzhi");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupfeimorenzhi((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupcszbh1")) {
      Object obj = map.get("lookupcszbh1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupcszbh1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupjine1")) {
      Object obj = map.get("lookupjine1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupjine1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzfc4")) {
      Object obj = map.get("lookupzfc4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupzfc4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupzx4")) {
      Object obj = map.get("lookupzx4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupzx4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupxs4")) {
      Object obj = map.get("lookupxs4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupxs4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupbez4")) {
      Object obj = map.get("lookupbez4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupbez4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupriqi4")) {
      Object obj = map.get("lookupriqi4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupriqi4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupmjx4")) {
      Object obj = map.get("lookupmjx4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupmjx4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookupcszbh4")) {
      Object obj = map.get("lookupcszbh4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLookupcszbh4((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
