package com.xforceplus.yanzheng23150.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 票据类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-13
 */
public enum InvoiceType1 {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType1(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType1 fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            default:
                return null;
        }
    }
}
