package com.xforceplus.yanzheng23150.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 被lookup对象1130
 * </p>
 *
 * @author ultraman
 * @since 2022-01-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Beilookup1130 implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 字符串
   */
  private String zfc;

  /**
   * 布尔值
   */
  private Boolean bez;

  /**
   * 浮点型
   */
  private BigDecimal fdx;

  /**
   * 枚举型
   */
  private String mjx;

  /**
   * 纯数字编号
   */
  private Long cszbh;

  /**
   * 整型
   */
  private Long zx;

  /**
   * 自增编号
   */
  private String zzbh;

  /**
   * 公式
   */
  private String gs;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("bez", bez);
      map.put("fdx", fdx);
      map.put("mjx", mjx);
      map.put("cszbh", cszbh);
      map.put("zx", zx);
      map.put("zzbh", zzbh);
      map.put("gs", gs);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static Beilookup1130 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Beilookup1130 entity = new Beilookup1130();
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bez")) {
      Object obj = map.get("bez");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBez((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setBez(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("fdx")) {
      Object obj = map.get("fdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("mjx")) {
      Object obj = map.get("mjx");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMjx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCszbh((Long)obj);
        } else if(obj instanceof String) {
          entity.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCszbh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx((Long)obj);
        } else if(obj instanceof String) {
          entity.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zzbh")) {
      Object obj = map.get("zzbh");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZzbh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gs")) {
      Object obj = map.get("gs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bez")) {
      Object obj = map.get("bez");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBez((Boolean)obj);
        } else if(obj instanceof String) {
          this.setBez(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("fdx")) {
      Object obj = map.get("fdx");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFdx((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFdx(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFdx(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setFdx(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFdx(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("mjx")) {
      Object obj = map.get("mjx");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMjx((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCszbh((Long)obj);
        } else if(obj instanceof String) {
          this.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCszbh(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setZx((Long)obj);
        } else if(obj instanceof String) {
          this.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setZx(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("zzbh")) {
      Object obj = map.get("zzbh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZzbh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gs")) {
      Object obj = map.get("gs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
