package com.xforceplus.yanzheng23150.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 业务字段对象
 * </p>
 *
 * @author ultraman
 * @since 2022-01-13
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Yewuobject implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 字符串
   */
  private String zfc;

  /**
   * 短文本
   */
  private String dwb;

  /**
   * 长文本
   */
  private String cwb;

  /**
   * 富文本
   */
  private String fuwb;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * URL
   */
  private String url;

  /**
   * 图片-2
   */
  private String tup;

  /**
   * 文件-2
   */
  private String wenj;

  /**
   * 图片-1
   */
  private String tup1;

  /**
   * 文件-1
   */
  private String wenj1;

  /**
   * 邮箱-指定格式
   */
  private String youxzdgs;

  /**
   * 邮箱-不限
   */
  private String youxbx;

  /**
   * 邮箱-自定义
   */
  private String youxzdy;

  /**
   * 电话-手机
   */
  private String dianhsj;

  /**
   * 电话-其他
   */
  private String dianhqt;

  /**
   * 地区
   */
  private String diqu;

  /**
   * 金额
   */
  private String jine;

  /**
   * 百分比
   */
  private String bfb;

  /**
   * 日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime riq;

  /**
   * 日期-年月
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime riqnianyue;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc", zfc);
      map.put("dwb", dwb);
      map.put("cwb", cwb);
      map.put("fuwb", fuwb);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("url", url);
      map.put("tup", tup);
      map.put("wenj", wenj);
      map.put("tup1", tup1);
      map.put("wenj1", wenj1);
      map.put("youxzdgs", youxzdgs);
      map.put("youxbx", youxbx);
      map.put("youxzdy", youxzdy);
      map.put("dianhsj", dianhsj);
      map.put("dianhqt", dianhqt);
      map.put("diqu", diqu);
      map.put("jine", jine);
      map.put("bfb", bfb);
      map.put("riq", BocpGenUtils.toTimestamp(riq));
      map.put("riqnianyue", BocpGenUtils.toTimestamp(riqnianyue));
      return map;
  }

  public static Yewuobject fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Yewuobject entity = new Yewuobject();
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dwb")) {
      Object obj = map.get("dwb");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDwb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cwb")) {
      Object obj = map.get("cwb");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCwb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fuwb")) {
      Object obj = map.get("fuwb");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFuwb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tup")) {
      Object obj = map.get("tup");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wenj")) {
      Object obj = map.get("wenj");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWenj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tup1")) {
      Object obj = map.get("tup1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTup1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wenj1")) {
      Object obj = map.get("wenj1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setWenj1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("youxzdgs")) {
      Object obj = map.get("youxzdgs");
      if(obj != null) {
        if(obj instanceof String){
          entity.setYouxzdgs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("youxbx")) {
      Object obj = map.get("youxbx");
      if(obj != null) {
        if(obj instanceof String){
          entity.setYouxbx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("youxzdy")) {
      Object obj = map.get("youxzdy");
      if(obj != null) {
        if(obj instanceof String){
          entity.setYouxzdy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dianhsj")) {
      Object obj = map.get("dianhsj");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDianhsj((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dianhqt")) {
      Object obj = map.get("dianhqt");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDianhqt((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diqu")) {
      Object obj = map.get("diqu");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiqu((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof String){
          entity.setJine((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bfb")) {
      Object obj = map.get("bfb");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBfb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("riq")) {
      Object obj = map.get("riq");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiq(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRiq((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRiq(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRiq(null);
      }
    }
    if(map.containsKey("riqnianyue")) {
      Object obj = map.get("riqnianyue");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiqnianyue(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRiqnianyue((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setRiqnianyue(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRiqnianyue(null);
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dwb")) {
      Object obj = map.get("dwb");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDwb((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cwb")) {
      Object obj = map.get("cwb");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCwb((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fuwb")) {
      Object obj = map.get("fuwb");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFuwb((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tup")) {
      Object obj = map.get("tup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wenj")) {
      Object obj = map.get("wenj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWenj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tup1")) {
      Object obj = map.get("tup1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTup1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wenj1")) {
      Object obj = map.get("wenj1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWenj1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("youxzdgs")) {
      Object obj = map.get("youxzdgs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYouxzdgs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("youxbx")) {
      Object obj = map.get("youxbx");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYouxbx((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("youxzdy")) {
      Object obj = map.get("youxzdy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYouxzdy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dianhsj")) {
      Object obj = map.get("dianhsj");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDianhsj((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dianhqt")) {
      Object obj = map.get("dianhqt");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDianhqt((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("diqu")) {
      Object obj = map.get("diqu");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiqu((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJine((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bfb")) {
      Object obj = map.get("bfb");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBfb((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("riq")) {
      Object obj = map.get("riq");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRiq(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRiq((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setRiq(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRiq(null);
      }
    }
    if(map.containsKey("riqnianyue")) {
      Object obj = map.get("riqnianyue");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRiqnianyue(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRiqnianyue((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setRiqnianyue(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRiqnianyue(null);
      }
    }
  }
}
