package com.xforceplus.yzxitongduixiang082901.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * inovice_type
 * </p>
 *
 * @author ultraman
 * @since 2023-09-21
 */
public enum InoviceType {

    C("c", "增值税普通发票"),
    CT("ct", "增值税电子普通发票（通行费）"),
    S("s", "增值税专用发票"),
    CE("ce", "增值税电子普通发票"),
    JU("ju", "增值税普通发票（卷票）"),
    SE("se", "增值税电子专用发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InoviceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InoviceType fromCode(String code){
        switch(code) {
            case "c":
                return C;
            case "ct":
                return CT;
            case "s":
                return S;
            case "ce":
                return CE;
            case "ju":
                return JU;
            case "se":
                return SE;
            default:
                return null;
        }
    }
}
