package com.xforceplus.yzxitongduixiang082901.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * test0210001
 * </p>
 *
 * @author ultraman
 * @since 2023-09-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Test0210001 implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * zfc1
   */
  private String zfc1;

  /**
   * cwb
   */
  private String cwb;

  /**
   * dwb3
   */
  private String dwb3;

  /**
   * zfc
   */
  private String zfc;

  /**
   * url
   */
  private String url;

  /**
   * tupian
   */
  private String tupian;

  /**
   * tupian2
   */
  private String tupian2;

  /**
   * wenjian
   */
  private String wenjian;

  /**
   * youxiang
   */
  private String youxiang;

  /**
   * youxiang2
   */
  private String youxiang2;

  /**
   * dh1
   */
  private String dh1;

  /**
   * diqu
   */
  private String diqu;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("zfc1", zfc1);
      map.put("cwb", cwb);
      map.put("dwb3", dwb3);
      map.put("zfc", zfc);
      map.put("url", url);
      map.put("tupian", tupian);
      map.put("tupian2", tupian2);
      map.put("wenjian", wenjian);
      map.put("youxiang", youxiang);
      map.put("youxiang2", youxiang2);
      map.put("dh1", dh1);
      map.put("diqu", diqu);

      return map;
  }

  public static Test0210001 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Test0210001 entity = new Test0210001();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfc1")) {
      Object obj = map.get("zfc1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cwb")) {
      Object obj = map.get("cwb");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCwb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dwb3")) {
      Object obj = map.get("dwb3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDwb3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tupian")) {
      Object obj = map.get("tupian");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTupian((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tupian2")) {
      Object obj = map.get("tupian2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTupian2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wenjian")) {
      Object obj = map.get("wenjian");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWenjian((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("youxiang")) {
      Object obj = map.get("youxiang");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYouxiang((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("youxiang2")) {
      Object obj = map.get("youxiang2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYouxiang2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dh1")) {
      Object obj = map.get("dh1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDh1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("diqu")) {
      Object obj = map.get("diqu");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDiqu((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zfc1")) {
      Object obj = map.get("zfc1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cwb")) {
      Object obj = map.get("cwb");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCwb((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dwb3")) {
      Object obj = map.get("dwb3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDwb3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("url")) {
      Object obj = map.get("url");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tupian")) {
      Object obj = map.get("tupian");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTupian((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tupian2")) {
      Object obj = map.get("tupian2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTupian2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wenjian")) {
      Object obj = map.get("wenjian");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWenjian((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("youxiang")) {
      Object obj = map.get("youxiang");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYouxiang((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("youxiang2")) {
      Object obj = map.get("youxiang2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYouxiang2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dh1")) {
      Object obj = map.get("dh1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDh1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("diqu")) {
      Object obj = map.get("diqu");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiqu((String)obj);
        }
      } else {
      }
    }
  }
}
