package com.xforceplus.yzxitongduixiang082901.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * test0304001
 * </p>
 *
 * @author ultraman
 * @since 2023-09-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Test0304001 implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * zfc1
   */
  private String zfc1;

  /**
   * zfc2
   */
  private String zfc2;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * zfcjh
   */
  private String zfcjh;

  /**
   * zx
   */
  private Long zx;

  /**
   * xs
   */
  private BigDecimal xs;

  /**
   * jine
   */
  private BigDecimal jine;

  /**
   * zx1
   */
  private Long zx1;

  /**
   * xs1
   */
  private BigDecimal xs1;

  /**
   * xs2
   */
  private BigDecimal xs2;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("zfc1", zfc1);
      map.put("zfc2", zfc2);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("zfcjh", zfcjh);
      map.put("zx", zx);
      map.put("xs", xs);
      map.put("jine", jine);
      map.put("zx1", zx1);
      map.put("xs1", xs1);
      map.put("xs2", xs2);

      return map;
  }

  public static Test0304001 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Test0304001 entity = new Test0304001();
    if(map.containsKey("zfc1")) {
      Object obj = map.get("zfc1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfc2")) {
      Object obj = map.get("zfc2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfcjh")) {
      Object obj = map.get("zfcjh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfcjh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("xs")) {
      Object obj = map.get("xs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJine((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("zx1")) {
      Object obj = map.get("zx1");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx1((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZx1(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("xs1")) {
      Object obj = map.get("xs1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXs1((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXs1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXs1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXs1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXs1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("xs2")) {
      Object obj = map.get("xs2");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXs2((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXs2(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXs2(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXs2(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXs2(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("zfc1")) {
      Object obj = map.get("zfc1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zfc2")) {
      Object obj = map.get("zfc2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zfcjh")) {
      Object obj = map.get("zfcjh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfcjh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setZx(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("xs")) {
      Object obj = map.get("xs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setXs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setXs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setXs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setXs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setXs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJine((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("zx1")) {
      Object obj = map.get("zx1");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setZx1((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZx1(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setZx1(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("xs1")) {
      Object obj = map.get("xs1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setXs1((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setXs1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setXs1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setXs1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setXs1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("xs2")) {
      Object obj = map.get("xs2");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setXs2((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setXs2(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setXs2(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setXs2(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setXs2(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
  }
}
