package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.Bo2;
import com.xforceplus.yzxitongduixiang082901.service.IBo2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-01-09
 */
@RestController
public class Bo2Controller {

  @Autowired
  private IBo2Service bo2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bo2 ${table.comment}
   * @return
   */
  @GetMapping("/bo2s" )
  public XfR getBo2s(XfPage page, Bo2 bo2) {
    return XfR.ok(bo2ServiceImpl.page(page, Wrappers.query(bo2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bo2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bo2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bo2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/bo2s")
  public XfR save(@RequestBody Bo2 bo2) {
     return XfR.ok(bo2ServiceImpl.save(bo2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bo2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/bo2s/{id}")
  public XfR putUpdate(@RequestBody Bo2 bo2,@PathVariable Long id) {
      bo2.setId(id);
      return XfR.ok(bo2ServiceImpl.updateById(bo2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bo2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bo2s/{id}")
  public XfR patchUpdate(@RequestBody Bo2 bo2,@PathVariable Long id) {
      Bo2 upbo2 = bo2ServiceImpl.getById(id);
      if(upbo2 != null){
        upbo2 = ObjectCopyUtils.copyProperties(bo2,upbo2,true);
      }
      return XfR.ok(bo2ServiceImpl.updateById(upbo2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bo2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bo2ServiceImpl.removeById(id));
  }

  @PostMapping("/bo2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bo2");
     params.put("request", condition);

     return XfR.ok(bo2ServiceImpl.querys(params));
  }

}
