package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.DemoBo;
import com.xforceplus.yzxitongduixiang082901.service.IDemoBoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-01-09
 */
@RestController
public class DemoBoController {

  @Autowired
  private IDemoBoService demoBoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param demoBo ${table.comment}
   * @return
   */
  @GetMapping("/demobos" )
  public XfR getDemoBos(XfPage page, DemoBo demoBo) {
    return XfR.ok(demoBoServiceImpl.page(page, Wrappers.query(demoBo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/demobos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(demoBoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param demoBo ${table.comment}
   * @return XfR
   */
  @PostMapping("/demobos")
  public XfR save(@RequestBody DemoBo demoBo) {
     return XfR.ok(demoBoServiceImpl.save(demoBo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param demoBo ${table.comment}
   * @return XfR
   */
  @PutMapping("/demobos/{id}")
  public XfR putUpdate(@RequestBody DemoBo demoBo,@PathVariable Long id) {
      demoBo.setId(id);
      return XfR.ok(demoBoServiceImpl.updateById(demoBo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param demoBo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/demobos/{id}")
  public XfR patchUpdate(@RequestBody DemoBo demoBo,@PathVariable Long id) {
      DemoBo updemoBo = demoBoServiceImpl.getById(id);
      if(updemoBo != null){
        updemoBo = ObjectCopyUtils.copyProperties(demoBo,updemoBo,true);
      }
      return XfR.ok(demoBoServiceImpl.updateById(updemoBo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/demobos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(demoBoServiceImpl.removeById(id));
  }

  @PostMapping("/demobos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "demo_bo");
     params.put("request", condition);

     return XfR.ok(demoBoServiceImpl.querys(params));
  }

}
