package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.Inmeijuobject;
import com.xforceplus.yzxitongduixiang082901.service.IInmeijuobjectService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * inmeijuobject前端控制器
 *
 * @author ultraman
 * @date 2023-01-09
 */
@RestController
public class InmeijuobjectController {

  @Autowired
  private IInmeijuobjectService inmeijuobjectServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param inmeijuobject inmeijuobject
   * @return
   */
  @GetMapping("/inmeijuobjects" )
  public XfR getInmeijuobjects(XfPage page, Inmeijuobject inmeijuobject) {
    return XfR.ok(inmeijuobjectServiceImpl.page(page, Wrappers.query(inmeijuobject)));
  }

  /**
   * 通过id查询inmeijuobject
   * @param  id
   * @return XfR
   */
  @GetMapping("/inmeijuobjects/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(inmeijuobjectServiceImpl.getById(id));
  }

  /**
   * 新增inmeijuobject
   * @param inmeijuobject inmeijuobject
   * @return XfR
   */
  @PostMapping("/inmeijuobjects")
  public XfR save(@RequestBody Inmeijuobject inmeijuobject) {
     return XfR.ok(inmeijuobjectServiceImpl.save(inmeijuobject));
  }

  /**
   * 修改-传入修改后的全部数据inmeijuobject
   * @param inmeijuobject inmeijuobject
   * @return XfR
   */
  @PutMapping("/inmeijuobjects/{id}")
  public XfR putUpdate(@RequestBody Inmeijuobject inmeijuobject,@PathVariable Long id) {
      inmeijuobject.setId(id);
      return XfR.ok(inmeijuobjectServiceImpl.updateById(inmeijuobject));
  }

  /**
   * 修改-传入修改的数据inmeijuobject
   * @param inmeijuobject inmeijuobject
   * @return XfR
   */
  @PatchMapping("/inmeijuobjects/{id}")
  public XfR patchUpdate(@RequestBody Inmeijuobject inmeijuobject,@PathVariable Long id) {
      Inmeijuobject upinmeijuobject = inmeijuobjectServiceImpl.getById(id);
      if(upinmeijuobject != null){
        upinmeijuobject = ObjectCopyUtils.copyProperties(inmeijuobject,upinmeijuobject,true);
      }
      return XfR.ok(inmeijuobjectServiceImpl.updateById(upinmeijuobject));
  }

  /**
   * 通过id删除inmeijuobject
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/inmeijuobjects/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(inmeijuobjectServiceImpl.removeById(id));
  }

  @PostMapping("/inmeijuobjects/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "inmeijuobject");
     params.put("request", condition);

     return XfR.ok(inmeijuobjectServiceImpl.querys(params));
  }

}
