package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.Juhe111401;
import com.xforceplus.yzxitongduixiang082901.service.IJuhe111401Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * juhe111401前端控制器
 *
 * @author ultraman
 * @date 2023-01-09
 */
@RestController
public class Juhe111401Controller {

  @Autowired
  private IJuhe111401Service juhe111401ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param juhe111401 juhe111401
   * @return
   */
  @GetMapping("/juhe111401s" )
  public XfR getJuhe111401s(XfPage page, Juhe111401 juhe111401) {
    return XfR.ok(juhe111401ServiceImpl.page(page, Wrappers.query(juhe111401)));
  }

  /**
   * 通过id查询juhe111401
   * @param  id
   * @return XfR
   */
  @GetMapping("/juhe111401s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(juhe111401ServiceImpl.getById(id));
  }

  /**
   * 新增juhe111401
   * @param juhe111401 juhe111401
   * @return XfR
   */
  @PostMapping("/juhe111401s")
  public XfR save(@RequestBody Juhe111401 juhe111401) {
     return XfR.ok(juhe111401ServiceImpl.save(juhe111401));
  }

  /**
   * 修改-传入修改后的全部数据juhe111401
   * @param juhe111401 juhe111401
   * @return XfR
   */
  @PutMapping("/juhe111401s/{id}")
  public XfR putUpdate(@RequestBody Juhe111401 juhe111401,@PathVariable Long id) {
      juhe111401.setId(id);
      return XfR.ok(juhe111401ServiceImpl.updateById(juhe111401));
  }

  /**
   * 修改-传入修改的数据juhe111401
   * @param juhe111401 juhe111401
   * @return XfR
   */
  @PatchMapping("/juhe111401s/{id}")
  public XfR patchUpdate(@RequestBody Juhe111401 juhe111401,@PathVariable Long id) {
      Juhe111401 upjuhe111401 = juhe111401ServiceImpl.getById(id);
      if(upjuhe111401 != null){
        upjuhe111401 = ObjectCopyUtils.copyProperties(juhe111401,upjuhe111401,true);
      }
      return XfR.ok(juhe111401ServiceImpl.updateById(upjuhe111401));
  }

  /**
   * 通过id删除juhe111401
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/juhe111401s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(juhe111401ServiceImpl.removeById(id));
  }

  @PostMapping("/juhe111401s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "juhe111401");
     params.put("request", condition);

     return XfR.ok(juhe111401ServiceImpl.querys(params));
  }

}
