package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.Test101801;
import com.xforceplus.yzxitongduixiang082901.service.ITest101801Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test101801前端控制器
 *
 * @author ultraman
 * @date 2023-01-09
 */
@RestController
public class Test101801Controller {

  @Autowired
  private ITest101801Service test101801ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test101801 test101801
   * @return
   */
  @GetMapping("/test101801s" )
  public XfR getTest101801s(XfPage page, Test101801 test101801) {
    return XfR.ok(test101801ServiceImpl.page(page, Wrappers.query(test101801)));
  }

  /**
   * 通过id查询test101801
   * @param  id
   * @return XfR
   */
  @GetMapping("/test101801s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test101801ServiceImpl.getById(id));
  }

  /**
   * 新增test101801
   * @param test101801 test101801
   * @return XfR
   */
  @PostMapping("/test101801s")
  public XfR save(@RequestBody Test101801 test101801) {
     return XfR.ok(test101801ServiceImpl.save(test101801));
  }

  /**
   * 修改-传入修改后的全部数据test101801
   * @param test101801 test101801
   * @return XfR
   */
  @PutMapping("/test101801s/{id}")
  public XfR putUpdate(@RequestBody Test101801 test101801,@PathVariable Long id) {
      test101801.setId(id);
      return XfR.ok(test101801ServiceImpl.updateById(test101801));
  }

  /**
   * 修改-传入修改的数据test101801
   * @param test101801 test101801
   * @return XfR
   */
  @PatchMapping("/test101801s/{id}")
  public XfR patchUpdate(@RequestBody Test101801 test101801,@PathVariable Long id) {
      Test101801 uptest101801 = test101801ServiceImpl.getById(id);
      if(uptest101801 != null){
        uptest101801 = ObjectCopyUtils.copyProperties(test101801,uptest101801,true);
      }
      return XfR.ok(test101801ServiceImpl.updateById(uptest101801));
  }

  /**
   * 通过id删除test101801
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test101801s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test101801ServiceImpl.removeById(id));
  }

  @PostMapping("/test101801s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test101801");
     params.put("request", condition);

     return XfR.ok(test101801ServiceImpl.querys(params));
  }

}
