package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.TestAction2;
import com.xforceplus.yzxitongduixiang082901.service.ITestAction2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-01-09
 */
@RestController
public class TestAction2Controller {

  @Autowired
  private ITestAction2Service testAction2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testAction2 ${table.comment}
   * @return
   */
  @GetMapping("/testaction2s" )
  public XfR getTestAction2s(XfPage page, TestAction2 testAction2) {
    return XfR.ok(testAction2ServiceImpl.page(page, Wrappers.query(testAction2)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testaction2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testAction2ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testAction2 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testaction2s")
  public XfR save(@RequestBody TestAction2 testAction2) {
     return XfR.ok(testAction2ServiceImpl.save(testAction2));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testAction2 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testaction2s/{id}")
  public XfR putUpdate(@RequestBody TestAction2 testAction2,@PathVariable Long id) {
      testAction2.setId(id);
      return XfR.ok(testAction2ServiceImpl.updateById(testAction2));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testAction2 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testaction2s/{id}")
  public XfR patchUpdate(@RequestBody TestAction2 testAction2,@PathVariable Long id) {
      TestAction2 uptestAction2 = testAction2ServiceImpl.getById(id);
      if(uptestAction2 != null){
        uptestAction2 = ObjectCopyUtils.copyProperties(testAction2,uptestAction2,true);
      }
      return XfR.ok(testAction2ServiceImpl.updateById(uptestAction2));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testaction2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testAction2ServiceImpl.removeById(id));
  }

  @PostMapping("/testaction2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_action2");
     params.put("request", condition);

     return XfR.ok(testAction2ServiceImpl.querys(params));
  }

}
