package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.TestAction4;
import com.xforceplus.yzxitongduixiang082901.service.ITestAction4Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-01-09
 */
@RestController
public class TestAction4Controller {

  @Autowired
  private ITestAction4Service testAction4ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testAction4 ${table.comment}
   * @return
   */
  @GetMapping("/testaction4s" )
  public XfR getTestAction4s(XfPage page, TestAction4 testAction4) {
    return XfR.ok(testAction4ServiceImpl.page(page, Wrappers.query(testAction4)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testaction4s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testAction4ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testAction4 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testaction4s")
  public XfR save(@RequestBody TestAction4 testAction4) {
     return XfR.ok(testAction4ServiceImpl.save(testAction4));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testAction4 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testaction4s/{id}")
  public XfR putUpdate(@RequestBody TestAction4 testAction4,@PathVariable Long id) {
      testAction4.setId(id);
      return XfR.ok(testAction4ServiceImpl.updateById(testAction4));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testAction4 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testaction4s/{id}")
  public XfR patchUpdate(@RequestBody TestAction4 testAction4,@PathVariable Long id) {
      TestAction4 uptestAction4 = testAction4ServiceImpl.getById(id);
      if(uptestAction4 != null){
        uptestAction4 = ObjectCopyUtils.copyProperties(testAction4,uptestAction4,true);
      }
      return XfR.ok(testAction4ServiceImpl.updateById(uptestAction4));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testaction4s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testAction4ServiceImpl.removeById(id));
  }

  @PostMapping("/testaction4s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_action4");
     params.put("request", condition);

     return XfR.ok(testAction4ServiceImpl.querys(params));
  }

}
