package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.Testyyf;
import com.xforceplus.yzxitongduixiang082901.service.ITestyyfService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-01-09
 */
@RestController
public class TestyyfController {

  @Autowired
  private ITestyyfService testyyfServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testyyf ${table.comment}
   * @return
   */
  @GetMapping("/testyyfs" )
  public XfR getTestyyfs(XfPage page, Testyyf testyyf) {
    return XfR.ok(testyyfServiceImpl.page(page, Wrappers.query(testyyf)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testyyfs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testyyfServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testyyf ${table.comment}
   * @return XfR
   */
  @PostMapping("/testyyfs")
  public XfR save(@RequestBody Testyyf testyyf) {
     return XfR.ok(testyyfServiceImpl.save(testyyf));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testyyf ${table.comment}
   * @return XfR
   */
  @PutMapping("/testyyfs/{id}")
  public XfR putUpdate(@RequestBody Testyyf testyyf,@PathVariable Long id) {
      testyyf.setId(id);
      return XfR.ok(testyyfServiceImpl.updateById(testyyf));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testyyf ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testyyfs/{id}")
  public XfR patchUpdate(@RequestBody Testyyf testyyf,@PathVariable Long id) {
      Testyyf uptestyyf = testyyfServiceImpl.getById(id);
      if(uptestyyf != null){
        uptestyyf = ObjectCopyUtils.copyProperties(testyyf,uptestyyf,true);
      }
      return XfR.ok(testyyfServiceImpl.updateById(uptestyyf));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testyyfs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testyyfServiceImpl.removeById(id));
  }

  @PostMapping("/testyyfs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testyyf");
     params.put("request", condition);

     return XfR.ok(testyyfServiceImpl.querys(params));
  }

}
