package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.Bo1;
import com.xforceplus.yzxitongduixiang082901.service.IBo1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class Bo1Controller {

  @Autowired
  private IBo1Service bo1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bo1 ${table.comment}
   * @return
   */
  @GetMapping("/bo1s" )
  public XfR getBo1s(XfPage page, Bo1 bo1) {
    return XfR.ok(bo1ServiceImpl.page(page, Wrappers.query(bo1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bo1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bo1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bo1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/bo1s")
  public XfR save(@RequestBody Bo1 bo1) {
     return XfR.ok(bo1ServiceImpl.save(bo1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bo1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/bo1s/{id}")
  public XfR putUpdate(@RequestBody Bo1 bo1,@PathVariable Long id) {
      bo1.setId(id);
      return XfR.ok(bo1ServiceImpl.updateById(bo1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bo1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bo1s/{id}")
  public XfR patchUpdate(@RequestBody Bo1 bo1,@PathVariable Long id) {
      Bo1 upbo1 = bo1ServiceImpl.getById(id);
      if(upbo1 != null){
        upbo1 = ObjectCopyUtils.copyProperties(bo1,upbo1,true);
      }
      return XfR.ok(bo1ServiceImpl.updateById(upbo1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bo1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bo1ServiceImpl.removeById(id));
  }

  @PostMapping("/bo1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bo1");
     params.put("request", condition);

     return XfR.ok(bo1ServiceImpl.querys(params));
  }

}
