package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.Lookup020701;
import com.xforceplus.yzxitongduixiang082901.service.ILookup020701Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * lookup020701前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class Lookup020701Controller {

  @Autowired
  private ILookup020701Service lookup020701ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookup020701 lookup020701
   * @return
   */
  @GetMapping("/lookup020701s" )
  public XfR getLookup020701s(XfPage page, Lookup020701 lookup020701) {
    return XfR.ok(lookup020701ServiceImpl.page(page, Wrappers.query(lookup020701)));
  }

  /**
   * 通过id查询lookup020701
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookup020701s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookup020701ServiceImpl.getById(id));
  }

  /**
   * 新增lookup020701
   * @param lookup020701 lookup020701
   * @return XfR
   */
  @PostMapping("/lookup020701s")
  public XfR save(@RequestBody Lookup020701 lookup020701) {
     return XfR.ok(lookup020701ServiceImpl.save(lookup020701));
  }

  /**
   * 修改-传入修改后的全部数据lookup020701
   * @param lookup020701 lookup020701
   * @return XfR
   */
  @PutMapping("/lookup020701s/{id}")
  public XfR putUpdate(@RequestBody Lookup020701 lookup020701,@PathVariable Long id) {
      lookup020701.setId(id);
      return XfR.ok(lookup020701ServiceImpl.updateById(lookup020701));
  }

  /**
   * 修改-传入修改的数据lookup020701
   * @param lookup020701 lookup020701
   * @return XfR
   */
  @PatchMapping("/lookup020701s/{id}")
  public XfR patchUpdate(@RequestBody Lookup020701 lookup020701,@PathVariable Long id) {
      Lookup020701 uplookup020701 = lookup020701ServiceImpl.getById(id);
      if(uplookup020701 != null){
        uplookup020701 = ObjectCopyUtils.copyProperties(lookup020701,uplookup020701,true);
      }
      return XfR.ok(lookup020701ServiceImpl.updateById(uplookup020701));
  }

  /**
   * 通过id删除lookup020701
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookup020701s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookup020701ServiceImpl.removeById(id));
  }

  @PostMapping("/lookup020701s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookup020701");
     params.put("request", condition);

     return XfR.ok(lookup020701ServiceImpl.querys(params));
  }

}
