package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.Test102001;
import com.xforceplus.yzxitongduixiang082901.service.ITest102001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test102001前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class Test102001Controller {

  @Autowired
  private ITest102001Service test102001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test102001 test102001
   * @return
   */
  @GetMapping("/test102001s" )
  public XfR getTest102001s(XfPage page, Test102001 test102001) {
    return XfR.ok(test102001ServiceImpl.page(page, Wrappers.query(test102001)));
  }

  /**
   * 通过id查询test102001
   * @param  id
   * @return XfR
   */
  @GetMapping("/test102001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test102001ServiceImpl.getById(id));
  }

  /**
   * 新增test102001
   * @param test102001 test102001
   * @return XfR
   */
  @PostMapping("/test102001s")
  public XfR save(@RequestBody Test102001 test102001) {
     return XfR.ok(test102001ServiceImpl.save(test102001));
  }

  /**
   * 修改-传入修改后的全部数据test102001
   * @param test102001 test102001
   * @return XfR
   */
  @PutMapping("/test102001s/{id}")
  public XfR putUpdate(@RequestBody Test102001 test102001,@PathVariable Long id) {
      test102001.setId(id);
      return XfR.ok(test102001ServiceImpl.updateById(test102001));
  }

  /**
   * 修改-传入修改的数据test102001
   * @param test102001 test102001
   * @return XfR
   */
  @PatchMapping("/test102001s/{id}")
  public XfR patchUpdate(@RequestBody Test102001 test102001,@PathVariable Long id) {
      Test102001 uptest102001 = test102001ServiceImpl.getById(id);
      if(uptest102001 != null){
        uptest102001 = ObjectCopyUtils.copyProperties(test102001,uptest102001,true);
      }
      return XfR.ok(test102001ServiceImpl.updateById(uptest102001));
  }

  /**
   * 通过id删除test102001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test102001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test102001ServiceImpl.removeById(id));
  }

  @PostMapping("/test102001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test102001");
     params.put("request", condition);

     return XfR.ok(test102001ServiceImpl.querys(params));
  }

}
