package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.TestAction3;
import com.xforceplus.yzxitongduixiang082901.service.ITestAction3Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class TestAction3Controller {

  @Autowired
  private ITestAction3Service testAction3ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testAction3 ${table.comment}
   * @return
   */
  @GetMapping("/testaction3s" )
  public XfR getTestAction3s(XfPage page, TestAction3 testAction3) {
    return XfR.ok(testAction3ServiceImpl.page(page, Wrappers.query(testAction3)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testaction3s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testAction3ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testAction3 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testaction3s")
  public XfR save(@RequestBody TestAction3 testAction3) {
     return XfR.ok(testAction3ServiceImpl.save(testAction3));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testAction3 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testaction3s/{id}")
  public XfR putUpdate(@RequestBody TestAction3 testAction3,@PathVariable Long id) {
      testAction3.setId(id);
      return XfR.ok(testAction3ServiceImpl.updateById(testAction3));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testAction3 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testaction3s/{id}")
  public XfR patchUpdate(@RequestBody TestAction3 testAction3,@PathVariable Long id) {
      TestAction3 uptestAction3 = testAction3ServiceImpl.getById(id);
      if(uptestAction3 != null){
        uptestAction3 = ObjectCopyUtils.copyProperties(testAction3,uptestAction3,true);
      }
      return XfR.ok(testAction3ServiceImpl.updateById(uptestAction3));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testaction3s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testAction3ServiceImpl.removeById(id));
  }

  @PostMapping("/testaction3s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_action3");
     params.put("request", condition);

     return XfR.ok(testAction3ServiceImpl.querys(params));
  }

}
