package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.TestAction5;
import com.xforceplus.yzxitongduixiang082901.service.ITestAction5Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class TestAction5Controller {

  @Autowired
  private ITestAction5Service testAction5ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testAction5 ${table.comment}
   * @return
   */
  @GetMapping("/testaction5s" )
  public XfR getTestAction5s(XfPage page, TestAction5 testAction5) {
    return XfR.ok(testAction5ServiceImpl.page(page, Wrappers.query(testAction5)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testaction5s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testAction5ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testAction5 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testaction5s")
  public XfR save(@RequestBody TestAction5 testAction5) {
     return XfR.ok(testAction5ServiceImpl.save(testAction5));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testAction5 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testaction5s/{id}")
  public XfR putUpdate(@RequestBody TestAction5 testAction5,@PathVariable Long id) {
      testAction5.setId(id);
      return XfR.ok(testAction5ServiceImpl.updateById(testAction5));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testAction5 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testaction5s/{id}")
  public XfR patchUpdate(@RequestBody TestAction5 testAction5,@PathVariable Long id) {
      TestAction5 uptestAction5 = testAction5ServiceImpl.getById(id);
      if(uptestAction5 != null){
        uptestAction5 = ObjectCopyUtils.copyProperties(testAction5,uptestAction5,true);
      }
      return XfR.ok(testAction5ServiceImpl.updateById(uptestAction5));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testaction5s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testAction5ServiceImpl.removeById(id));
  }

  @PostMapping("/testaction5s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_action5");
     params.put("request", condition);

     return XfR.ok(testAction5ServiceImpl.querys(params));
  }

}
