package com.xforceplus.yzxitongduixiang082901.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.yzxitongduixiang082901.entity.TestAction;
import com.xforceplus.yzxitongduixiang082901.service.ITestActionService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-02-13
 */
@RestController
public class TestActionController {

  @Autowired
  private ITestActionService testActionServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testAction ${table.comment}
   * @return
   */
  @GetMapping("/testactions" )
  public XfR getTestActions(XfPage page, TestAction testAction) {
    return XfR.ok(testActionServiceImpl.page(page, Wrappers.query(testAction)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testactions/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testActionServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testAction ${table.comment}
   * @return XfR
   */
  @PostMapping("/testactions")
  public XfR save(@RequestBody TestAction testAction) {
     return XfR.ok(testActionServiceImpl.save(testAction));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testAction ${table.comment}
   * @return XfR
   */
  @PutMapping("/testactions/{id}")
  public XfR putUpdate(@RequestBody TestAction testAction,@PathVariable Long id) {
      testAction.setId(id);
      return XfR.ok(testActionServiceImpl.updateById(testAction));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testAction ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testactions/{id}")
  public XfR patchUpdate(@RequestBody TestAction testAction,@PathVariable Long id) {
      TestAction uptestAction = testActionServiceImpl.getById(id);
      if(uptestAction != null){
        uptestAction = ObjectCopyUtils.copyProperties(testAction,uptestAction,true);
      }
      return XfR.ok(testActionServiceImpl.updateById(uptestAction));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testactions/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testActionServiceImpl.removeById(id));
  }

  @PostMapping("/testactions/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_action");
     params.put("request", condition);

     return XfR.ok(testActionServiceImpl.querys(params));
  }

}
