package com.xforceplus.zidonghualiu1012.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * test032001
 * </p>
 *
 * @author ultraman
 * @since 2023-07-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Test032001 implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * xs
   */
  private BigDecimal xs;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * jine
   */
  private BigDecimal jine;

  /**
   * bfb
   */
  private BigDecimal bfb;

  /**
   * bez
   */
  private Boolean bez;

  /**
   * riqi
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime riqi;

  /**
   * 状态
   */
  private String status;

  /**
   * meiju062801
   */
  private String meiju062801;

  /**
   * mjx030101
   */
  private String mjx030101;

  /**
   * zfc
   */
  private String zfc;

  /**
   * gs
   */
  private String gs;

  /**
   * gssjc
   */
  private String gssjc;

  /**
   * zx
   */
  private Long zx;

  /**
   * gszx
   */
  private String gszx;

  /**
   * gsbez
   */
  private String gsbez;

  /**
   * gsxs
   */
  private String gsxs;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("xs", xs);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("jine", jine);
      map.put("bfb", bfb);
      map.put("bez", bez);
      map.put("riqi", BocpGenUtils.toTimestamp(riqi));
      map.put("status", status);
      map.put("meiju062801", meiju062801);
      map.put("mjx030101", mjx030101);
      map.put("zfc", zfc);
      map.put("gs", gs);
      map.put("gssjc", gssjc);
      map.put("zx", zx);
      map.put("gszx", gszx);
      map.put("gsbez", gsbez);
      map.put("gsxs", gsxs);

      return map;
  }

  public static Test032001 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Test032001 entity = new Test032001();
    if(map.containsKey("xs")) {
      Object obj = map.get("xs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJine((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bfb")) {
      Object obj = map.get("bfb");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBfb((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBfb(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBfb(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBfb(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBfb(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bez")) {
      Object obj = map.get("bez");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBez((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBez(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqi")) {
      Object obj = map.get("riqi");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiqi(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRiqi((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiqi(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRiqi(null);
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("meiju062801")) {
      Object obj = map.get("meiju062801");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMeiju062801((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mjx030101")) {
      Object obj = map.get("mjx030101");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMjx030101((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gs")) {
      Object obj = map.get("gs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gssjc")) {
      Object obj = map.get("gssjc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGssjc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("gszx")) {
      Object obj = map.get("gszx");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGszx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gsbez")) {
      Object obj = map.get("gsbez");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGsbez((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gsxs")) {
      Object obj = map.get("gsxs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGsxs((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("xs")) {
      Object obj = map.get("xs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setXs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setXs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setXs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setXs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setXs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJine((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bfb")) {
      Object obj = map.get("bfb");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBfb((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBfb(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBfb(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBfb(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBfb(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bez")) {
      Object obj = map.get("bez");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBez((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBez(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("riqi")) {
      Object obj = map.get("riqi");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRiqi(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRiqi((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRiqi(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRiqi(null);
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("meiju062801")) {
      Object obj = map.get("meiju062801");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMeiju062801((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mjx030101")) {
      Object obj = map.get("mjx030101");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMjx030101((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zfc")) {
      Object obj = map.get("zfc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gs")) {
      Object obj = map.get("gs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gssjc")) {
      Object obj = map.get("gssjc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGssjc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setZx(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("gszx")) {
      Object obj = map.get("gszx");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGszx((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gsbez")) {
      Object obj = map.get("gsbez");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGsbez((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gsxs")) {
      Object obj = map.get("gsxs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGsxs((String)obj);
        }
      } else {
      }
    }
  }
}
