package com.xforceplus.zidonghualiu1012.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * test0607001
 * </p>
 *
 * @author ultraman
 * @since 2023-07-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Test0607001 implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * zfc1
   */
  private String zfc1;

  /**
   * dwb
   */
  private String dwb;

  /**
   * email
   */
  private String email;

  /**
   * dh
   */
  private String dh;

  /**
   * areas
   */
  private String areas;

  /**
   * zfcjh
   */
  private String zfcjh;

  /**
   * cszbh
   */
  private Long cszbh;

  /**
   * zx
   */
  private Long zx;

  /**
   * xs
   */
  private BigDecimal xs;

  /**
   * jine
   */
  private BigDecimal jine;

  /**
   * bez
   */
  private Boolean bez;

  /**
   * riqi
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime riqi;

  /**
   * mjx0607002
   */
  private String mjx0607002;

  /**
   * gsmjx0607002
   */
  private String gsmjx0607002;

  /**
   * gs
   */
  private String gs;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("zfc1", zfc1);
      map.put("dwb", dwb);
      map.put("email", email);
      map.put("dh", dh);
      map.put("areas", areas);
      map.put("zfcjh", zfcjh);
      map.put("cszbh", cszbh);
      map.put("zx", zx);
      map.put("xs", xs);
      map.put("jine", jine);
      map.put("bez", bez);
      map.put("riqi", BocpGenUtils.toTimestamp(riqi));
      map.put("mjx0607002", mjx0607002);
      map.put("gsmjx0607002", gsmjx0607002);
      map.put("gs", gs);

      return map;
  }

  public static Test0607001 fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Test0607001 entity = new Test0607001();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfc1")) {
      Object obj = map.get("zfc1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfc1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dwb")) {
      Object obj = map.get("dwb");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDwb((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dh")) {
      Object obj = map.get("dh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("areas")) {
      Object obj = map.get("areas");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAreas((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zfcjh")) {
      Object obj = map.get("zfcjh");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZfcjh((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCszbh(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setZx(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("xs")) {
      Object obj = map.get("xs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setXs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setXs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setXs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setXs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setXs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJine((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bez")) {
      Object obj = map.get("bez");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setBez((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBez(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("riqi")) {
      Object obj = map.get("riqi");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRiqi(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRiqi((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRiqi(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRiqi(null);
      }
    }
    if(map.containsKey("mjx0607002")) {
      Object obj = map.get("mjx0607002");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMjx0607002((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gsmjx0607002")) {
      Object obj = map.get("gsmjx0607002");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGsmjx0607002((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gs")) {
      Object obj = map.get("gs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGs((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zfc1")) {
      Object obj = map.get("zfc1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfc1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dwb")) {
      Object obj = map.get("dwb");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDwb((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("email")) {
      Object obj = map.get("email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dh")) {
      Object obj = map.get("dh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("areas")) {
      Object obj = map.get("areas");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAreas((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zfcjh")) {
      Object obj = map.get("zfcjh");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZfcjh((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cszbh")) {
      Object obj = map.get("cszbh");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCszbh((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCszbh(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCszbh(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("zx")) {
      Object obj = map.get("zx");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setZx((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setZx(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setZx(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("xs")) {
      Object obj = map.get("xs");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setXs((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setXs(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setXs(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setXs(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setXs(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("jine")) {
      Object obj = map.get("jine");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJine((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJine(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJine(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJine(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJine(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bez")) {
      Object obj = map.get("bez");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setBez((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBez(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("riqi")) {
      Object obj = map.get("riqi");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRiqi(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRiqi((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRiqi(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRiqi(null);
      }
    }
    if(map.containsKey("mjx0607002")) {
      Object obj = map.get("mjx0607002");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMjx0607002((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gsmjx0607002")) {
      Object obj = map.get("gsmjx0607002");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGsmjx0607002((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gs")) {
      Object obj = map.get("gs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGs((String)obj);
        }
      } else {
      }
    }
  }
}
