package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Beilookup;
import com.xforceplus.zidonghualiu1012.service.IBeilookupService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * beilookup前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class BeilookupController {

  @Autowired
  private IBeilookupService beilookupServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param beilookup beilookup
   * @return
   */
  @GetMapping("/beilookups" )
  public XfR getBeilookups(XfPage page, Beilookup beilookup) {
    return XfR.ok(beilookupServiceImpl.page(page, Wrappers.query(beilookup)));
  }

  /**
   * 通过id查询beilookup
   * @param  id
   * @return XfR
   */
  @GetMapping("/beilookups/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(beilookupServiceImpl.getById(id));
  }

  /**
   * 新增beilookup
   * @param beilookup beilookup
   * @return XfR
   */
  @PostMapping("/beilookups")
  public XfR save(@RequestBody Beilookup beilookup) {
     return XfR.ok(beilookupServiceImpl.save(beilookup));
  }

  /**
   * 修改-传入修改后的全部数据beilookup
   * @param beilookup beilookup
   * @return XfR
   */
  @PutMapping("/beilookups/{id}")
  public XfR putUpdate(@RequestBody Beilookup beilookup,@PathVariable Long id) {
      beilookup.setId(id);
      return XfR.ok(beilookupServiceImpl.updateById(beilookup));
  }

  /**
   * 修改-传入修改的数据beilookup
   * @param beilookup beilookup
   * @return XfR
   */
  @PatchMapping("/beilookups/{id}")
  public XfR patchUpdate(@RequestBody Beilookup beilookup,@PathVariable Long id) {
      Beilookup upbeilookup = beilookupServiceImpl.getById(id);
      if(upbeilookup != null){
        upbeilookup = ObjectCopyUtils.copyProperties(beilookup,upbeilookup,true);
      }
      return XfR.ok(beilookupServiceImpl.updateById(upbeilookup));
  }

  /**
   * 通过id删除beilookup
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/beilookups/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(beilookupServiceImpl.removeById(id));
  }

  @PostMapping("/beilookups/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "beilookup");
     params.put("request", condition);

     return XfR.ok(beilookupServiceImpl.querys(params));
  }

}
