package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Juhe0301001;
import com.xforceplus.zidonghualiu1012.service.IJuhe0301001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * juhe0301001前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class Juhe0301001Controller {

  @Autowired
  private IJuhe0301001Service juhe0301001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param juhe0301001 juhe0301001
   * @return
   */
  @GetMapping("/juhe0301001s" )
  public XfR getJuhe0301001s(XfPage page, Juhe0301001 juhe0301001) {
    return XfR.ok(juhe0301001ServiceImpl.page(page, Wrappers.query(juhe0301001)));
  }

  /**
   * 通过id查询juhe0301001
   * @param  id
   * @return XfR
   */
  @GetMapping("/juhe0301001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(juhe0301001ServiceImpl.getById(id));
  }

  /**
   * 新增juhe0301001
   * @param juhe0301001 juhe0301001
   * @return XfR
   */
  @PostMapping("/juhe0301001s")
  public XfR save(@RequestBody Juhe0301001 juhe0301001) {
     return XfR.ok(juhe0301001ServiceImpl.save(juhe0301001));
  }

  /**
   * 修改-传入修改后的全部数据juhe0301001
   * @param juhe0301001 juhe0301001
   * @return XfR
   */
  @PutMapping("/juhe0301001s/{id}")
  public XfR putUpdate(@RequestBody Juhe0301001 juhe0301001,@PathVariable Long id) {
      juhe0301001.setId(id);
      return XfR.ok(juhe0301001ServiceImpl.updateById(juhe0301001));
  }

  /**
   * 修改-传入修改的数据juhe0301001
   * @param juhe0301001 juhe0301001
   * @return XfR
   */
  @PatchMapping("/juhe0301001s/{id}")
  public XfR patchUpdate(@RequestBody Juhe0301001 juhe0301001,@PathVariable Long id) {
      Juhe0301001 upjuhe0301001 = juhe0301001ServiceImpl.getById(id);
      if(upjuhe0301001 != null){
        upjuhe0301001 = ObjectCopyUtils.copyProperties(juhe0301001,upjuhe0301001,true);
      }
      return XfR.ok(juhe0301001ServiceImpl.updateById(upjuhe0301001));
  }

  /**
   * 通过id删除juhe0301001
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/juhe0301001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(juhe0301001ServiceImpl.removeById(id));
  }

  @PostMapping("/juhe0301001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "juhe0301001");
     params.put("request", condition);

     return XfR.ok(juhe0301001ServiceImpl.querys(params));
  }

}
