package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Lookupzfc;
import com.xforceplus.zidonghualiu1012.service.ILookupzfcService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * lookupzfc前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class LookupzfcController {

  @Autowired
  private ILookupzfcService lookupzfcServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param lookupzfc lookupzfc
   * @return
   */
  @GetMapping("/lookupzfcs" )
  public XfR getLookupzfcs(XfPage page, Lookupzfc lookupzfc) {
    return XfR.ok(lookupzfcServiceImpl.page(page, Wrappers.query(lookupzfc)));
  }

  /**
   * 通过id查询lookupzfc
   * @param  id
   * @return XfR
   */
  @GetMapping("/lookupzfcs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(lookupzfcServiceImpl.getById(id));
  }

  /**
   * 新增lookupzfc
   * @param lookupzfc lookupzfc
   * @return XfR
   */
  @PostMapping("/lookupzfcs")
  public XfR save(@RequestBody Lookupzfc lookupzfc) {
     return XfR.ok(lookupzfcServiceImpl.save(lookupzfc));
  }

  /**
   * 修改-传入修改后的全部数据lookupzfc
   * @param lookupzfc lookupzfc
   * @return XfR
   */
  @PutMapping("/lookupzfcs/{id}")
  public XfR putUpdate(@RequestBody Lookupzfc lookupzfc,@PathVariable Long id) {
      lookupzfc.setId(id);
      return XfR.ok(lookupzfcServiceImpl.updateById(lookupzfc));
  }

  /**
   * 修改-传入修改的数据lookupzfc
   * @param lookupzfc lookupzfc
   * @return XfR
   */
  @PatchMapping("/lookupzfcs/{id}")
  public XfR patchUpdate(@RequestBody Lookupzfc lookupzfc,@PathVariable Long id) {
      Lookupzfc uplookupzfc = lookupzfcServiceImpl.getById(id);
      if(uplookupzfc != null){
        uplookupzfc = ObjectCopyUtils.copyProperties(lookupzfc,uplookupzfc,true);
      }
      return XfR.ok(lookupzfcServiceImpl.updateById(uplookupzfc));
  }

  /**
   * 通过id删除lookupzfc
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/lookupzfcs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(lookupzfcServiceImpl.removeById(id));
  }

  @PostMapping("/lookupzfcs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "lookupzfc");
     params.put("request", condition);

     return XfR.ok(lookupzfcServiceImpl.querys(params));
  }

}
