package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Mingxi030101;
import com.xforceplus.zidonghualiu1012.service.IMingxi030101Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * mingxi030101前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class Mingxi030101Controller {

  @Autowired
  private IMingxi030101Service mingxi030101ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param mingxi030101 mingxi030101
   * @return
   */
  @GetMapping("/mingxi030101s" )
  public XfR getMingxi030101s(XfPage page, Mingxi030101 mingxi030101) {
    return XfR.ok(mingxi030101ServiceImpl.page(page, Wrappers.query(mingxi030101)));
  }

  /**
   * 通过id查询mingxi030101
   * @param  id
   * @return XfR
   */
  @GetMapping("/mingxi030101s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(mingxi030101ServiceImpl.getById(id));
  }

  /**
   * 新增mingxi030101
   * @param mingxi030101 mingxi030101
   * @return XfR
   */
  @PostMapping("/mingxi030101s")
  public XfR save(@RequestBody Mingxi030101 mingxi030101) {
     return XfR.ok(mingxi030101ServiceImpl.save(mingxi030101));
  }

  /**
   * 修改-传入修改后的全部数据mingxi030101
   * @param mingxi030101 mingxi030101
   * @return XfR
   */
  @PutMapping("/mingxi030101s/{id}")
  public XfR putUpdate(@RequestBody Mingxi030101 mingxi030101,@PathVariable Long id) {
      mingxi030101.setId(id);
      return XfR.ok(mingxi030101ServiceImpl.updateById(mingxi030101));
  }

  /**
   * 修改-传入修改的数据mingxi030101
   * @param mingxi030101 mingxi030101
   * @return XfR
   */
  @PatchMapping("/mingxi030101s/{id}")
  public XfR patchUpdate(@RequestBody Mingxi030101 mingxi030101,@PathVariable Long id) {
      Mingxi030101 upmingxi030101 = mingxi030101ServiceImpl.getById(id);
      if(upmingxi030101 != null){
        upmingxi030101 = ObjectCopyUtils.copyProperties(mingxi030101,upmingxi030101,true);
      }
      return XfR.ok(mingxi030101ServiceImpl.updateById(upmingxi030101));
  }

  /**
   * 通过id删除mingxi030101
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/mingxi030101s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(mingxi030101ServiceImpl.removeById(id));
  }

  @PostMapping("/mingxi030101s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "mingxi030101");
     params.put("request", condition);

     return XfR.ok(mingxi030101ServiceImpl.querys(params));
  }

}
