package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Test030101;
import com.xforceplus.zidonghualiu1012.service.ITest030101Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * test030101前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class Test030101Controller {

  @Autowired
  private ITest030101Service test030101ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param test030101 test030101
   * @return
   */
  @GetMapping("/test030101s" )
  public XfR getTest030101s(XfPage page, Test030101 test030101) {
    return XfR.ok(test030101ServiceImpl.page(page, Wrappers.query(test030101)));
  }

  /**
   * 通过id查询test030101
   * @param  id
   * @return XfR
   */
  @GetMapping("/test030101s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(test030101ServiceImpl.getById(id));
  }

  /**
   * 新增test030101
   * @param test030101 test030101
   * @return XfR
   */
  @PostMapping("/test030101s")
  public XfR save(@RequestBody Test030101 test030101) {
     return XfR.ok(test030101ServiceImpl.save(test030101));
  }

  /**
   * 修改-传入修改后的全部数据test030101
   * @param test030101 test030101
   * @return XfR
   */
  @PutMapping("/test030101s/{id}")
  public XfR putUpdate(@RequestBody Test030101 test030101,@PathVariable Long id) {
      test030101.setId(id);
      return XfR.ok(test030101ServiceImpl.updateById(test030101));
  }

  /**
   * 修改-传入修改的数据test030101
   * @param test030101 test030101
   * @return XfR
   */
  @PatchMapping("/test030101s/{id}")
  public XfR patchUpdate(@RequestBody Test030101 test030101,@PathVariable Long id) {
      Test030101 uptest030101 = test030101ServiceImpl.getById(id);
      if(uptest030101 != null){
        uptest030101 = ObjectCopyUtils.copyProperties(test030101,uptest030101,true);
      }
      return XfR.ok(test030101ServiceImpl.updateById(uptest030101));
  }

  /**
   * 通过id删除test030101
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/test030101s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(test030101ServiceImpl.removeById(id));
  }

  @PostMapping("/test030101s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test030101");
     params.put("request", condition);

     return XfR.ok(test030101ServiceImpl.querys(params));
  }

}
