package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Testerr030301;
import com.xforceplus.zidonghualiu1012.service.ITesterr030301Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testerr030301前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class Testerr030301Controller {

  @Autowired
  private ITesterr030301Service testerr030301ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testerr030301 testerr030301
   * @return
   */
  @GetMapping("/testerr030301s" )
  public XfR getTesterr030301s(XfPage page, Testerr030301 testerr030301) {
    return XfR.ok(testerr030301ServiceImpl.page(page, Wrappers.query(testerr030301)));
  }

  /**
   * 通过id查询testerr030301
   * @param  id
   * @return XfR
   */
  @GetMapping("/testerr030301s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testerr030301ServiceImpl.getById(id));
  }

  /**
   * 新增testerr030301
   * @param testerr030301 testerr030301
   * @return XfR
   */
  @PostMapping("/testerr030301s")
  public XfR save(@RequestBody Testerr030301 testerr030301) {
     return XfR.ok(testerr030301ServiceImpl.save(testerr030301));
  }

  /**
   * 修改-传入修改后的全部数据testerr030301
   * @param testerr030301 testerr030301
   * @return XfR
   */
  @PutMapping("/testerr030301s/{id}")
  public XfR putUpdate(@RequestBody Testerr030301 testerr030301,@PathVariable Long id) {
      testerr030301.setId(id);
      return XfR.ok(testerr030301ServiceImpl.updateById(testerr030301));
  }

  /**
   * 修改-传入修改的数据testerr030301
   * @param testerr030301 testerr030301
   * @return XfR
   */
  @PatchMapping("/testerr030301s/{id}")
  public XfR patchUpdate(@RequestBody Testerr030301 testerr030301,@PathVariable Long id) {
      Testerr030301 uptesterr030301 = testerr030301ServiceImpl.getById(id);
      if(uptesterr030301 != null){
        uptesterr030301 = ObjectCopyUtils.copyProperties(testerr030301,uptesterr030301,true);
      }
      return XfR.ok(testerr030301ServiceImpl.updateById(uptesterr030301));
  }

  /**
   * 通过id删除testerr030301
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testerr030301s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testerr030301ServiceImpl.removeById(id));
  }

  @PostMapping("/testerr030301s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testerr030301");
     params.put("request", condition);

     return XfR.ok(testerr030301ServiceImpl.querys(params));
  }

}
