package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Zdhl0221002;
import com.xforceplus.zidonghualiu1012.service.IZdhl0221002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * zdhl0221002前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class Zdhl0221002Controller {

  @Autowired
  private IZdhl0221002Service zdhl0221002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zdhl0221002 zdhl0221002
   * @return
   */
  @GetMapping("/zdhl0221002s" )
  public XfR getZdhl0221002s(XfPage page, Zdhl0221002 zdhl0221002) {
    return XfR.ok(zdhl0221002ServiceImpl.page(page, Wrappers.query(zdhl0221002)));
  }

  /**
   * 通过id查询zdhl0221002
   * @param  id
   * @return XfR
   */
  @GetMapping("/zdhl0221002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zdhl0221002ServiceImpl.getById(id));
  }

  /**
   * 新增zdhl0221002
   * @param zdhl0221002 zdhl0221002
   * @return XfR
   */
  @PostMapping("/zdhl0221002s")
  public XfR save(@RequestBody Zdhl0221002 zdhl0221002) {
     return XfR.ok(zdhl0221002ServiceImpl.save(zdhl0221002));
  }

  /**
   * 修改-传入修改后的全部数据zdhl0221002
   * @param zdhl0221002 zdhl0221002
   * @return XfR
   */
  @PutMapping("/zdhl0221002s/{id}")
  public XfR putUpdate(@RequestBody Zdhl0221002 zdhl0221002,@PathVariable Long id) {
      zdhl0221002.setId(id);
      return XfR.ok(zdhl0221002ServiceImpl.updateById(zdhl0221002));
  }

  /**
   * 修改-传入修改的数据zdhl0221002
   * @param zdhl0221002 zdhl0221002
   * @return XfR
   */
  @PatchMapping("/zdhl0221002s/{id}")
  public XfR patchUpdate(@RequestBody Zdhl0221002 zdhl0221002,@PathVariable Long id) {
      Zdhl0221002 upzdhl0221002 = zdhl0221002ServiceImpl.getById(id);
      if(upzdhl0221002 != null){
        upzdhl0221002 = ObjectCopyUtils.copyProperties(zdhl0221002,upzdhl0221002,true);
      }
      return XfR.ok(zdhl0221002ServiceImpl.updateById(upzdhl0221002));
  }

  /**
   * 通过id删除zdhl0221002
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zdhl0221002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zdhl0221002ServiceImpl.removeById(id));
  }

  @PostMapping("/zdhl0221002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zdhl0221002");
     params.put("request", condition);

     return XfR.ok(zdhl0221002ServiceImpl.querys(params));
  }

}
