package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Zdhl0221003;
import com.xforceplus.zidonghualiu1012.service.IZdhl0221003Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * zdhl0221003前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class Zdhl0221003Controller {

  @Autowired
  private IZdhl0221003Service zdhl0221003ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zdhl0221003 zdhl0221003
   * @return
   */
  @GetMapping("/zdhl0221003s" )
  public XfR getZdhl0221003s(XfPage page, Zdhl0221003 zdhl0221003) {
    return XfR.ok(zdhl0221003ServiceImpl.page(page, Wrappers.query(zdhl0221003)));
  }

  /**
   * 通过id查询zdhl0221003
   * @param  id
   * @return XfR
   */
  @GetMapping("/zdhl0221003s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zdhl0221003ServiceImpl.getById(id));
  }

  /**
   * 新增zdhl0221003
   * @param zdhl0221003 zdhl0221003
   * @return XfR
   */
  @PostMapping("/zdhl0221003s")
  public XfR save(@RequestBody Zdhl0221003 zdhl0221003) {
     return XfR.ok(zdhl0221003ServiceImpl.save(zdhl0221003));
  }

  /**
   * 修改-传入修改后的全部数据zdhl0221003
   * @param zdhl0221003 zdhl0221003
   * @return XfR
   */
  @PutMapping("/zdhl0221003s/{id}")
  public XfR putUpdate(@RequestBody Zdhl0221003 zdhl0221003,@PathVariable Long id) {
      zdhl0221003.setId(id);
      return XfR.ok(zdhl0221003ServiceImpl.updateById(zdhl0221003));
  }

  /**
   * 修改-传入修改的数据zdhl0221003
   * @param zdhl0221003 zdhl0221003
   * @return XfR
   */
  @PatchMapping("/zdhl0221003s/{id}")
  public XfR patchUpdate(@RequestBody Zdhl0221003 zdhl0221003,@PathVariable Long id) {
      Zdhl0221003 upzdhl0221003 = zdhl0221003ServiceImpl.getById(id);
      if(upzdhl0221003 != null){
        upzdhl0221003 = ObjectCopyUtils.copyProperties(zdhl0221003,upzdhl0221003,true);
      }
      return XfR.ok(zdhl0221003ServiceImpl.updateById(upzdhl0221003));
  }

  /**
   * 通过id删除zdhl0221003
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zdhl0221003s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zdhl0221003ServiceImpl.removeById(id));
  }

  @PostMapping("/zdhl0221003s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zdhl0221003");
     params.put("request", condition);

     return XfR.ok(zdhl0221003ServiceImpl.querys(params));
  }

}
