package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Zdhl0221004;
import com.xforceplus.zidonghualiu1012.service.IZdhl0221004Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * zdhl0221004前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class Zdhl0221004Controller {

  @Autowired
  private IZdhl0221004Service zdhl0221004ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zdhl0221004 zdhl0221004
   * @return
   */
  @GetMapping("/zdhl0221004s" )
  public XfR getZdhl0221004s(XfPage page, Zdhl0221004 zdhl0221004) {
    return XfR.ok(zdhl0221004ServiceImpl.page(page, Wrappers.query(zdhl0221004)));
  }

  /**
   * 通过id查询zdhl0221004
   * @param  id
   * @return XfR
   */
  @GetMapping("/zdhl0221004s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zdhl0221004ServiceImpl.getById(id));
  }

  /**
   * 新增zdhl0221004
   * @param zdhl0221004 zdhl0221004
   * @return XfR
   */
  @PostMapping("/zdhl0221004s")
  public XfR save(@RequestBody Zdhl0221004 zdhl0221004) {
     return XfR.ok(zdhl0221004ServiceImpl.save(zdhl0221004));
  }

  /**
   * 修改-传入修改后的全部数据zdhl0221004
   * @param zdhl0221004 zdhl0221004
   * @return XfR
   */
  @PutMapping("/zdhl0221004s/{id}")
  public XfR putUpdate(@RequestBody Zdhl0221004 zdhl0221004,@PathVariable Long id) {
      zdhl0221004.setId(id);
      return XfR.ok(zdhl0221004ServiceImpl.updateById(zdhl0221004));
  }

  /**
   * 修改-传入修改的数据zdhl0221004
   * @param zdhl0221004 zdhl0221004
   * @return XfR
   */
  @PatchMapping("/zdhl0221004s/{id}")
  public XfR patchUpdate(@RequestBody Zdhl0221004 zdhl0221004,@PathVariable Long id) {
      Zdhl0221004 upzdhl0221004 = zdhl0221004ServiceImpl.getById(id);
      if(upzdhl0221004 != null){
        upzdhl0221004 = ObjectCopyUtils.copyProperties(zdhl0221004,upzdhl0221004,true);
      }
      return XfR.ok(zdhl0221004ServiceImpl.updateById(upzdhl0221004));
  }

  /**
   * 通过id删除zdhl0221004
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zdhl0221004s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zdhl0221004ServiceImpl.removeById(id));
  }

  @PostMapping("/zdhl0221004s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zdhl0221004");
     params.put("request", condition);

     return XfR.ok(zdhl0221004ServiceImpl.querys(params));
  }

}
