package com.xforceplus.zidonghualiu1012.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.zidonghualiu1012.entity.Zhu030101;
import com.xforceplus.zidonghualiu1012.service.IZhu030101Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * zhu030101前端控制器
 *
 * @author ultraman
 * @date 2023-03-04
 */
@RestController
public class Zhu030101Controller {

  @Autowired
  private IZhu030101Service zhu030101ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param zhu030101 zhu030101
   * @return
   */
  @GetMapping("/zhu030101s" )
  public XfR getZhu030101s(XfPage page, Zhu030101 zhu030101) {
    return XfR.ok(zhu030101ServiceImpl.page(page, Wrappers.query(zhu030101)));
  }

  /**
   * 通过id查询zhu030101
   * @param  id
   * @return XfR
   */
  @GetMapping("/zhu030101s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(zhu030101ServiceImpl.getById(id));
  }

  /**
   * 新增zhu030101
   * @param zhu030101 zhu030101
   * @return XfR
   */
  @PostMapping("/zhu030101s")
  public XfR save(@RequestBody Zhu030101 zhu030101) {
     return XfR.ok(zhu030101ServiceImpl.save(zhu030101));
  }

  /**
   * 修改-传入修改后的全部数据zhu030101
   * @param zhu030101 zhu030101
   * @return XfR
   */
  @PutMapping("/zhu030101s/{id}")
  public XfR putUpdate(@RequestBody Zhu030101 zhu030101,@PathVariable Long id) {
      zhu030101.setId(id);
      return XfR.ok(zhu030101ServiceImpl.updateById(zhu030101));
  }

  /**
   * 修改-传入修改的数据zhu030101
   * @param zhu030101 zhu030101
   * @return XfR
   */
  @PatchMapping("/zhu030101s/{id}")
  public XfR patchUpdate(@RequestBody Zhu030101 zhu030101,@PathVariable Long id) {
      Zhu030101 upzhu030101 = zhu030101ServiceImpl.getById(id);
      if(upzhu030101 != null){
        upzhu030101 = ObjectCopyUtils.copyProperties(zhu030101,upzhu030101,true);
      }
      return XfR.ok(zhu030101ServiceImpl.updateById(upzhu030101));
  }

  /**
   * 通过id删除zhu030101
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/zhu030101s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(zhu030101ServiceImpl.removeById(id));
  }

  @PostMapping("/zhu030101s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "zhu030101");
     params.put("request", condition);

     return XfR.ok(zhu030101ServiceImpl.querys(params));
  }

}
