/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.opengauss;

import lombok.Generated;
import org.apache.shardingsphere.db.protocol.opengauss.codec.OpenGaussPacketCodecEngine;
import org.apache.shardingsphere.db.protocol.postgresql.constant.PostgreSQLServerInfo;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.frontend.context.FrontendContext;
import org.apache.shardingsphere.proxy.frontend.opengauss.authentication.OpenGaussAuthenticationEngine;
import org.apache.shardingsphere.proxy.frontend.opengauss.command.OpenGaussCommandExecuteEngine;
import org.apache.shardingsphere.proxy.frontend.postgresql.PostgreSQLFrontendEngine;
import org.apache.shardingsphere.proxy.frontend.spi.DatabaseProtocolFrontendEngine;

public final class OpenGaussFrontendEngine
implements DatabaseProtocolFrontendEngine {
    private final PostgreSQLFrontendEngine postgreSQLFrontendEngine = new PostgreSQLFrontendEngine();
    private final OpenGaussAuthenticationEngine authenticationEngine = new OpenGaussAuthenticationEngine();
    private final OpenGaussCommandExecuteEngine commandExecuteEngine = new OpenGaussCommandExecuteEngine();
    private final OpenGaussPacketCodecEngine codecEngine = new OpenGaussPacketCodecEngine();

    public FrontendContext getFrontendContext() {
        return this.postgreSQLFrontendEngine.getFrontendContext();
    }

    public void setDatabaseVersion(String databaseName, String databaseVersion) {
        PostgreSQLServerInfo.setServerVersion((String)databaseVersion);
    }

    public void release(ConnectionSession connectionSession) {
        this.postgreSQLFrontendEngine.release(connectionSession);
    }

    public void handleException(ConnectionSession connectionSession) {
        if (connectionSession.getTransactionStatus().isInTransaction() && !connectionSession.getTransactionStatus().isRollbackOnly()) {
            connectionSession.getTransactionStatus().setRollbackOnly(true);
        }
    }

    public String getType() {
        return "openGauss";
    }

    @Generated
    public OpenGaussAuthenticationEngine getAuthenticationEngine() {
        return this.authenticationEngine;
    }

    @Generated
    public OpenGaussCommandExecuteEngine getCommandExecuteEngine() {
        return this.commandExecuteEngine;
    }

    @Generated
    public OpenGaussPacketCodecEngine getCodecEngine() {
        return this.codecEngine;
    }
}

